
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p625630_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755083_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the namespace for XMP metadata.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for XmpNamespaceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="XmpNamespaceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="namespaceName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="namespacePrefix" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="namespaceURI" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "XmpNamespaceType")
public class XmpNamespaceType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p625630_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755083_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the namespace for the XMP data (e.g. "webPDF XMP Properties")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "namespaceName")
    protected String namespaceName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p625630_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755083_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the prefix for the XMP data (e.g. "webpdf")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "namespacePrefix")
    protected String namespacePrefix;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p625630_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755083_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the URI for the XMP data (e.g. "http://ns.webpdf.de/webpdf/6.0/")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "namespaceURI")
    protected String namespaceURI;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p625630_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755083_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the namespace for the XMP data (e.g. "webPDF XMP Properties")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespaceName() {
        if (namespaceName == null) {
            return "";
        } else {
            return namespaceName;
        }
    }

    /**
     * Sets the value of the namespaceName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getNamespaceName()
     */
    public void setNamespaceName(String value) {
        this.namespaceName = value;
    }

    public boolean isSetNamespaceName() {
        return (this.namespaceName!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p625630_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755083_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the prefix for the XMP data (e.g. "webpdf")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespacePrefix() {
        if (namespacePrefix == null) {
            return "";
        } else {
            return namespacePrefix;
        }
    }

    /**
     * Sets the value of the namespacePrefix property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getNamespacePrefix()
     */
    public void setNamespacePrefix(String value) {
        this.namespacePrefix = value;
    }

    public boolean isSetNamespacePrefix() {
        return (this.namespacePrefix!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p625630_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755083_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the URI for the XMP data (e.g. "http://ns.webpdf.de/webpdf/6.0/")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespaceURI() {
        if (namespaceURI == null) {
            return "";
        } else {
            return namespaceURI;
        }
    }

    /**
     * Sets the value of the namespaceURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getNamespaceURI()
     */
    public void setNamespaceURI(String value) {
        this.namespaceURI = value;
    }

    public boolean isSetNamespaceURI() {
        return (this.namespaceURI!= null);
    }

}
