
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The "URLConverter" web service van be used to convert URL resources (websites) to a PDF document.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Please keep the limitations of HTML conversion in mind (see chapter "HTML conversion").&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for UrlConverterType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="UrlConverterType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="basicAuth" type="{http://schema.webpdf.de/1.0/operation}HttpBasicAuthType" minOccurs="0"/>
 *         <element name="page" type="{http://schema.webpdf.de/1.0/operation}UrlConverterPageType" minOccurs="0"/>
 *         <element name="proxy" type="{http://schema.webpdf.de/1.0/operation}HttpProxyType" minOccurs="0"/>
 *       </all>
 *       <attribute name="url" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UrlConverterType", propOrder = {

})
public class UrlConverterType
    implements ParameterInterface
{

    protected HttpBasicAuthType basicAuth;
    protected UrlConverterPageType page;
    protected HttpProxyType proxy;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The URL for the resource to be converted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "url")
    protected String url;

    /**
     * Gets the value of the basicAuth property.
     * 
     * @return
     *     possible object is
     *     {@link HttpBasicAuthType }
     *     
     */
    public HttpBasicAuthType getBasicAuth() {
        return basicAuth;
    }

    /**
     * Sets the value of the basicAuth property.
     * 
     * @param value
     *     allowed object is
     *     {@link HttpBasicAuthType }
     *     
     */
    public void setBasicAuth(HttpBasicAuthType value) {
        this.basicAuth = value;
    }

    public boolean isSetBasicAuth() {
        return (this.basicAuth!= null);
    }

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link UrlConverterPageType }
     *     
     */
    public UrlConverterPageType getPage() {
        return page;
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link UrlConverterPageType }
     *     
     */
    public void setPage(UrlConverterPageType value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    /**
     * Gets the value of the proxy property.
     * 
     * @return
     *     possible object is
     *     {@link HttpProxyType }
     *     
     */
    public HttpProxyType getProxy() {
        return proxy;
    }

    /**
     * Sets the value of the proxy property.
     * 
     * @param value
     *     allowed object is
     *     {@link HttpProxyType }
     *     
     */
    public void setProxy(HttpProxyType value) {
        this.proxy = value;
    }

    public boolean isSetProxy() {
        return (this.proxy!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p672351_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p68930_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The URL for the resource to be converted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUrl() {
        if (url == null) {
            return "";
        } else {
            return url;
        }
    }

    /**
     * Sets the value of the url property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUrl()
     */
    public void setUrl(String value) {
        this.url = value;
    }

    public boolean isSetUrl() {
        return (this.url!= null);
    }

}
