
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Creates a page transition animation for a PDF full screen presentation. It is possible to specify several transition elements for different page ranges.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TransitionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TransitionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="duration" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="style" type="{http://schema.webpdf.de/1.0/operation}TransitionStyleType" default="none" />
 *       <attribute name="direction" type="{http://schema.webpdf.de/1.0/operation}TransitionDirection" default="none" />
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="autoScrollTime" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="autoScroll" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="flyScale" type="{http://www.w3.org/2001/XMLSchema}float" default="1" />
 *       <attribute name="flyAreaOpaque" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransitionType")
public class TransitionType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommendable.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "duration")
    protected Float duration;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of transition animation.&#13;
     *                         &lt;ul&gt;&lt;li&gt;blinds = Crossfades&lt;/li&gt;&lt;li&gt;box = Crossfades in a rectangular pattern&lt;/li&gt;&lt;li&gt;cover = Covers&lt;/li&gt;&lt;li&gt;dissolve = Dissolves&lt;/li&gt;&lt;li&gt;fade = Fades&lt;/li&gt;&lt;li&gt;fly = Page flies in&lt;/li&gt;&lt;li&gt;glitter = Page dissolves and is replaced&lt;/li&gt;&lt;li&gt;push = Page is pushed out&lt;/li&gt;&lt;li&gt;split = Splits page&lt;/li&gt;&lt;li&gt;uncover = Uncovers page&lt;/li&gt;&lt;li&gt;wipe = Wipes page&lt;/li&gt;&lt;li&gt;none = No special effect&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "style")
    protected TransitionStyleType style;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The direction of the transition animation (provided that it can be applied to the animation).&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight = From left to right&lt;/li&gt;&lt;li&gt;bottomToTop = From bottom to top&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left&lt;/li&gt;&lt;li&gt;topToBottom = From top to bottom&lt;/li&gt;&lt;li&gt;topLeftToBottomRight = From top left to bottom right&lt;/li&gt;&lt;li&gt;none = Use the default value for the animation&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "direction")
    protected TransitionDirection direction;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page number or page range (e.g., "1,5-6,9") to which the transition animation should be applied.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The time it will take for the next page to be automatically shown completely in full screen presentation mode.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "autoScrollTime")
    protected Float autoScrollTime;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the next page to be automatically shown completely in full screen presentation mode after a specific time.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "autoScroll")
    protected Boolean autoScroll;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "flyScale")
    protected Float flyScale;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define whether the page background for the page that flies in should be transparent initially.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "flyAreaOpaque")
    protected Boolean flyAreaOpaque;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommendable.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getDuration() {
        if (duration == null) {
            return  1.0F;
        } else {
            return duration;
        }
    }

    /**
     * Sets the value of the duration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getDuration()
     */
    public void setDuration(float value) {
        this.duration = value;
    }

    public boolean isSetDuration() {
        return (this.duration!= null);
    }

    public void unsetDuration() {
        this.duration = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of transition animation.&#13;
     *                         &lt;ul&gt;&lt;li&gt;blinds = Crossfades&lt;/li&gt;&lt;li&gt;box = Crossfades in a rectangular pattern&lt;/li&gt;&lt;li&gt;cover = Covers&lt;/li&gt;&lt;li&gt;dissolve = Dissolves&lt;/li&gt;&lt;li&gt;fade = Fades&lt;/li&gt;&lt;li&gt;fly = Page flies in&lt;/li&gt;&lt;li&gt;glitter = Page dissolves and is replaced&lt;/li&gt;&lt;li&gt;push = Page is pushed out&lt;/li&gt;&lt;li&gt;split = Splits page&lt;/li&gt;&lt;li&gt;uncover = Uncovers page&lt;/li&gt;&lt;li&gt;wipe = Wipes page&lt;/li&gt;&lt;li&gt;none = No special effect&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TransitionStyleType }
     *     
     */
    public TransitionStyleType getStyle() {
        if (style == null) {
            return TransitionStyleType.NONE;
        } else {
            return style;
        }
    }

    /**
     * Sets the value of the style property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransitionStyleType }
     *     
     * @see #getStyle()
     */
    public void setStyle(TransitionStyleType value) {
        this.style = value;
    }

    public boolean isSetStyle() {
        return (this.style!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The direction of the transition animation (provided that it can be applied to the animation).&#13;
     *                         &lt;ul&gt;&lt;li&gt;leftToRight = From left to right&lt;/li&gt;&lt;li&gt;bottomToTop = From bottom to top&lt;/li&gt;&lt;li&gt;rightToLeft = From right to left&lt;/li&gt;&lt;li&gt;topToBottom = From top to bottom&lt;/li&gt;&lt;li&gt;topLeftToBottomRight = From top left to bottom right&lt;/li&gt;&lt;li&gt;none = Use the default value for the animation&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TransitionDirection }
     *     
     */
    public TransitionDirection getDirection() {
        if (direction == null) {
            return TransitionDirection.NONE;
        } else {
            return direction;
        }
    }

    /**
     * Sets the value of the direction property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransitionDirection }
     *     
     * @see #getDirection()
     */
    public void setDirection(TransitionDirection value) {
        this.direction = value;
    }

    public boolean isSetDirection() {
        return (this.direction!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the page number or page range (e.g., "1,5-6,9") to which the transition animation should be applied.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The time it will take for the next page to be automatically shown completely in full screen presentation mode.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getAutoScrollTime() {
        if (autoScrollTime == null) {
            return  0.0F;
        } else {
            return autoScrollTime;
        }
    }

    /**
     * Sets the value of the autoScrollTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getAutoScrollTime()
     */
    public void setAutoScrollTime(float value) {
        this.autoScrollTime = value;
    }

    public boolean isSetAutoScrollTime() {
        return (this.autoScrollTime!= null);
    }

    public void unsetAutoScrollTime() {
        this.autoScrollTime = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the next page to be automatically shown completely in full screen presentation mode after a specific time.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAutoScroll() {
        if (autoScroll == null) {
            return false;
        } else {
            return autoScroll;
        }
    }

    /**
     * Sets the value of the autoScroll property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isAutoScroll()
     */
    public void setAutoScroll(boolean value) {
        this.autoScroll = value;
    }

    public boolean isSetAutoScroll() {
        return (this.autoScroll!= null);
    }

    public void unsetAutoScroll() {
        this.autoScroll = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getFlyScale() {
        if (flyScale == null) {
            return  1.0F;
        } else {
            return flyScale;
        }
    }

    /**
     * Sets the value of the flyScale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getFlyScale()
     */
    public void setFlyScale(float value) {
        this.flyScale = value;
    }

    public boolean isSetFlyScale() {
        return (this.flyScale!= null);
    }

    public void unsetFlyScale() {
        this.flyScale = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Option for the "fly" animation style - used to define whether the page background for the page that flies in should be transparent initially.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFlyAreaOpaque() {
        if (flyAreaOpaque == null) {
            return false;
        } else {
            return flyAreaOpaque;
        }
    }

    /**
     * Sets the value of the flyAreaOpaque property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFlyAreaOpaque()
     */
    public void setFlyAreaOpaque(boolean value) {
        this.flyAreaOpaque = value;
    }

    public boolean isSetFlyAreaOpaque() {
        return (this.flyAreaOpaque!= null);
    }

    public void unsetFlyAreaOpaque() {
        this.flyAreaOpaque = null;
    }

}
