
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The transcribe operation element can be used to convert a PDF document into other document formats. Errors and inaccuracies can always occur during such conversions, so the endpoint allows a report to be generated to detect and evaluate possible transfer errors both in the event of an error and in the event of a success.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TranscribeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TranscribeType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <choice>
 *         <element name="html" type="{http://schema.webpdf.de/1.0/operation}HtmlTranscribeType"/>
 *       </choice>
 *       <attribute name="errorReport" type="{http://schema.webpdf.de/1.0/operation}TranscribeErrorReportType" default="none" />
 *       <attribute name="successReport" type="{http://schema.webpdf.de/1.0/operation}TranscribeSuccessReportType" default="none" />
 *       <attribute name="failureLevel" type="{http://schema.webpdf.de/1.0/operation}FailureType" default="error" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TranscribeType", propOrder = {
    "html"
})
public class TranscribeType
    extends BaseToolboxType
{

    protected HtmlTranscribeType html;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines if and in which form the XML report for a failed conversion is returned.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = XML report is not returned&lt;/li&gt;&lt;li&gt;message = XML report will be delivered as part of the error message&lt;/li&gt;&lt;li&gt;file = XML report is saved to file&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "errorReport")
    protected TranscribeErrorReportType errorReport;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines if and in which form the XML report for a successful conversion is returned.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = XML report is not returned&lt;/li&gt;&lt;li&gt;linked = XML report is appended to the end of the target document.&lt;/li&gt;&lt;li&gt;zip = target document and XML report are packed together in a ZIP archive.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The format of the document created at "errorReport" and "successReport" is described via the http://schema.webpdf.de/1.0/report/transcribe.xsd schema.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "successReport")
    protected TranscribeSuccessReportType successReport;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines at which error level the conversion should fail, you can use this parameter to automatically reject also results with lower precision as failure&#13;
     *                                 &lt;ul&gt;&lt;li&gt;warning = Documents for which warnings occur will also cause the conversion to fail.&lt;/li&gt;&lt;li&gt;missingContent = Documents for which not all content could be converted correctly will also be considered as failures.&lt;/li&gt;&lt;li&gt;error = Only if a conversion of the document did not lead to any meaningful result document, this is evaluated as failure, even if contents should be missing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "failureLevel")
    protected FailureType failureLevel;

    /**
     * Gets the value of the html property.
     * 
     * @return
     *     possible object is
     *     {@link HtmlTranscribeType }
     *     
     */
    public HtmlTranscribeType getHtml() {
        return html;
    }

    /**
     * Sets the value of the html property.
     * 
     * @param value
     *     allowed object is
     *     {@link HtmlTranscribeType }
     *     
     */
    public void setHtml(HtmlTranscribeType value) {
        this.html = value;
    }

    public boolean isSetHtml() {
        return (this.html!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines if and in which form the XML report for a failed conversion is returned.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = XML report is not returned&lt;/li&gt;&lt;li&gt;message = XML report will be delivered as part of the error message&lt;/li&gt;&lt;li&gt;file = XML report is saved to file&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TranscribeErrorReportType }
     *     
     */
    public TranscribeErrorReportType getErrorReport() {
        if (errorReport == null) {
            return TranscribeErrorReportType.NONE;
        } else {
            return errorReport;
        }
    }

    /**
     * Sets the value of the errorReport property.
     * 
     * @param value
     *     allowed object is
     *     {@link TranscribeErrorReportType }
     *     
     * @see #getErrorReport()
     */
    public void setErrorReport(TranscribeErrorReportType value) {
        this.errorReport = value;
    }

    public boolean isSetErrorReport() {
        return (this.errorReport!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines if and in which form the XML report for a successful conversion is returned.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = XML report is not returned&lt;/li&gt;&lt;li&gt;linked = XML report is appended to the end of the target document.&lt;/li&gt;&lt;li&gt;zip = target document and XML report are packed together in a ZIP archive.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                                 The format of the document created at "errorReport" and "successReport" is described via the http://schema.webpdf.de/1.0/report/transcribe.xsd schema.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TranscribeSuccessReportType }
     *     
     */
    public TranscribeSuccessReportType getSuccessReport() {
        if (successReport == null) {
            return TranscribeSuccessReportType.NONE;
        } else {
            return successReport;
        }
    }

    /**
     * Sets the value of the successReport property.
     * 
     * @param value
     *     allowed object is
     *     {@link TranscribeSuccessReportType }
     *     
     * @see #getSuccessReport()
     */
    public void setSuccessReport(TranscribeSuccessReportType value) {
        this.successReport = value;
    }

    public boolean isSetSuccessReport() {
        return (this.successReport!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines at which error level the conversion should fail, you can use this parameter to automatically reject also results with lower precision as failure&#13;
     *                                 &lt;ul&gt;&lt;li&gt;warning = Documents for which warnings occur will also cause the conversion to fail.&lt;/li&gt;&lt;li&gt;missingContent = Documents for which not all content could be converted correctly will also be considered as failures.&lt;/li&gt;&lt;li&gt;error = Only if a conversion of the document did not lead to any meaningful result document, this is evaluated as failure, even if contents should be missing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FailureType }
     *     
     */
    public FailureType getFailureLevel() {
        if (failureLevel == null) {
            return FailureType.ERROR;
        } else {
            return failureLevel;
        }
    }

    /**
     * Sets the value of the failureLevel property.
     * 
     * @param value
     *     allowed object is
     *     {@link FailureType }
     *     
     * @see #getFailureLevel()
     */
    public void setFailureLevel(FailureType value) {
        this.failureLevel = value;
    }

    public boolean isSetFailureLevel() {
        return (this.failureLevel!= null);
    }

}
