
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines if and in which form the XML report for a successful conversion is returned.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = XML report is not returned&lt;/li&gt;&lt;li&gt;linked = XML report is appended to the end of the target document.&lt;/li&gt;&lt;li&gt;zip = target document and XML report are packed together in a ZIP archive.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     The format of the document created at "errorReport" and "successReport" is described via the http://schema.webpdf.de/1.0/report/transcribe.xsd schema.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TranscribeSuccessReportType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="TranscribeSuccessReportType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="zip"/>
 *     <enumeration value="linked"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TranscribeSuccessReportType")
@XmlEnum
public enum TranscribeSuccessReportType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("zip")
    ZIP("zip"),
    @XmlEnumValue("linked")
    LINKED("linked");
    private final String value;

    TranscribeSuccessReportType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static TranscribeSuccessReportType fromValue(String v) {
        for (TranscribeSuccessReportType c: TranscribeSuccessReportType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
