
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines a target TIFF image format.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TiffType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TiffType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ImageBaseType">
 *       <attribute name="multipage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="compression" type="{http://schema.webpdf.de/1.0/operation}TiffCompressionType" default="none" />
 *       <attribute name="jpegQuality" default="80">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="blackAndWhiteQuality" type="{http://schema.webpdf.de/1.0/operation}TiffBlackAndWhiteQualityType" default="high" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TiffType")
public class TiffType
    extends ImageBaseType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," a "multi-page TIFF" will be created when multiple pages are exported as "tif" images. All the pages will be exported to a single file, and a ZIP file with individual images will not be generated.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "multipage")
    protected Boolean multipage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to specify the compression method when exporting pages as "tif" images. The following values are available:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = No compression&lt;/li&gt;&lt;li&gt;rle = TIFF CCITT Modified Huffman RLE compression&lt;/li&gt;&lt;li&gt;deflate = TIFF Deflate lossless compression (Zip-in-TIFF).&lt;/li&gt;&lt;li&gt;group3 = TIFF CCITT Group 3 fax encoding&lt;/li&gt;&lt;li&gt;group4 = TIFF CCITT Group 4 fax encoding&lt;/li&gt;&lt;li&gt;jpeg = TIFF JPEG-in-TIFF compression&lt;/li&gt;&lt;li&gt;lzw = TIFF LZW compression&lt;/li&gt;&lt;li&gt;packbits = TIFF Byte-oriented run-length encoding "PackBits" compression&lt;/li&gt;&lt;li&gt;zlib = TIFF ZLib compression&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "compression")
    protected TiffCompressionType compression;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When exporting to "jpg" format, this parameter can be used to define the image's quality as a percentage. The value must fall between 0 and 100. The larger the value, the better the quality and the lower the compression level.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "jpegQuality")
    protected Integer jpegQuality;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;For "tif" exports, this parameter is used to define the quality of black-and-white images if "group3" or "group4" is used as a compression method. The higher the quality, the more time that will be required in order to render the image:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;low = Direct conversion (best reserved for "text only" content)&lt;/li&gt;&lt;li&gt;middle = A diffusion filter will be applied to the image before conversion&lt;/li&gt;&lt;li&gt;high = Greyscale conversion and a diffusion filter will be applied to the image before conversion&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "blackAndWhiteQuality")
    protected TiffBlackAndWhiteQualityType blackAndWhiteQuality;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," a "multi-page TIFF" will be created when multiple pages are exported as "tif" images. All the pages will be exported to a single file, and a ZIP file with individual images will not be generated.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMultipage() {
        if (multipage == null) {
            return false;
        } else {
            return multipage;
        }
    }

    /**
     * Sets the value of the multipage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMultipage()
     */
    public void setMultipage(boolean value) {
        this.multipage = value;
    }

    public boolean isSetMultipage() {
        return (this.multipage!= null);
    }

    public void unsetMultipage() {
        this.multipage = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to specify the compression method when exporting pages as "tif" images. The following values are available:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = No compression&lt;/li&gt;&lt;li&gt;rle = TIFF CCITT Modified Huffman RLE compression&lt;/li&gt;&lt;li&gt;deflate = TIFF Deflate lossless compression (Zip-in-TIFF).&lt;/li&gt;&lt;li&gt;group3 = TIFF CCITT Group 3 fax encoding&lt;/li&gt;&lt;li&gt;group4 = TIFF CCITT Group 4 fax encoding&lt;/li&gt;&lt;li&gt;jpeg = TIFF JPEG-in-TIFF compression&lt;/li&gt;&lt;li&gt;lzw = TIFF LZW compression&lt;/li&gt;&lt;li&gt;packbits = TIFF Byte-oriented run-length encoding "PackBits" compression&lt;/li&gt;&lt;li&gt;zlib = TIFF ZLib compression&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TiffCompressionType }
     *     
     */
    public TiffCompressionType getCompression() {
        if (compression == null) {
            return TiffCompressionType.NONE;
        } else {
            return compression;
        }
    }

    /**
     * Sets the value of the compression property.
     * 
     * @param value
     *     allowed object is
     *     {@link TiffCompressionType }
     *     
     * @see #getCompression()
     */
    public void setCompression(TiffCompressionType value) {
        this.compression = value;
    }

    public boolean isSetCompression() {
        return (this.compression!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When exporting to "jpg" format, this parameter can be used to define the image's quality as a percentage. The value must fall between 0 and 100. The larger the value, the better the quality and the lower the compression level.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getJpegQuality() {
        if (jpegQuality == null) {
            return  80;
        } else {
            return jpegQuality;
        }
    }

    /**
     * Sets the value of the jpegQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getJpegQuality()
     */
    public void setJpegQuality(int value) {
        this.jpegQuality = value;
    }

    public boolean isSetJpegQuality() {
        return (this.jpegQuality!= null);
    }

    public void unsetJpegQuality() {
        this.jpegQuality = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;For "tif" exports, this parameter is used to define the quality of black-and-white images if "group3" or "group4" is used as a compression method. The higher the quality, the more time that will be required in order to render the image:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;low = Direct conversion (best reserved for "text only" content)&lt;/li&gt;&lt;li&gt;middle = A diffusion filter will be applied to the image before conversion&lt;/li&gt;&lt;li&gt;high = Greyscale conversion and a diffusion filter will be applied to the image before conversion&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TiffBlackAndWhiteQualityType }
     *     
     */
    public TiffBlackAndWhiteQualityType getBlackAndWhiteQuality() {
        if (blackAndWhiteQuality == null) {
            return TiffBlackAndWhiteQualityType.HIGH;
        } else {
            return blackAndWhiteQuality;
        }
    }

    /**
     * Sets the value of the blackAndWhiteQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link TiffBlackAndWhiteQualityType }
     *     
     * @see #getBlackAndWhiteQuality()
     */
    public void setBlackAndWhiteQuality(TiffBlackAndWhiteQualityType value) {
        this.blackAndWhiteQuality = value;
    }

    public boolean isSetBlackAndWhiteQuality() {
        return (this.blackAndWhiteQuality!= null);
    }

}
