
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The split operation element can be used to split documents.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     Acroforms are correctly split, but contained XFA data are removed.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SplitType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SplitType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <attribute name="mode" type="{http://schema.webpdf.de/1.0/operation}SplitModeType" default="last" />
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="1" />
 *       <attribute name="startPage" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="fileNameTemplate" type="{http://www.w3.org/2001/XMLSchema}string" default="page[%d]" />
 *       <attribute name="singleFileAsZip" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SplitType")
public class SplitType
    extends BaseToolboxType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the mode used to split the PDF document.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;last = Last page - Uses "pages" to define the last page that will be contained in the new PDF document.&lt;/li&gt;&lt;li&gt;first = First page - Uses "pages" to define the first page that will be contained in the new PDF document.&lt;/li&gt;&lt;li&gt;list = List of pages - Uses "pages" to define a list of pages that should be extracted from the document. A single PDF document will be created on the basis of this list.&lt;/li&gt;&lt;li&gt;single = Selected pages - Uses the "pages" attribute to define a list of pages that should be extracted from the document. And creates a ZIP file with the corresponding pages.&lt;/li&gt;&lt;li&gt;each = Every nth page - Uses the "pages" attribute to define the interval at which pages should be extracted. The "startPage" attribute is used to define the page on which the process will start. The result will be a ZIP file.&lt;/li&gt;&lt;li&gt;group = Group pages - Multiple pages will be added to a single PDF document. The "pages" attribute can be used to define how many pages will be saved in a single PDF document. The "startPage" attribute is used to define the page on which the process will start. The result will be a ZIP file.&lt;/li&gt;&lt;li&gt;burst = Ungroup pages - A new PDF document will be generated from each page. The result will be a ZIP file.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "mode")
    protected SplitModeType mode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which page(s) should be used for the split operation. The page number can be an individual page, a page range, or a list (separated with commas) (e.g. "1,5-6,9"). The "mode" attribute defines whether a single page or a range of pages can be used: With "last" and "first," an individual page is specified; with "list," a list of pages can be used.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used for "each" and "group" in the "mode" attribute.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "startPage")
    protected Integer startPage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the "split" operation generates a ZIP document (please refer to "mode"), this template can be used to define the file name of the PDF document in the ZIP document. The "%d" placeholder must be used in the template in order to define the PDF document page.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fileNameTemplate")
    protected String fileNameTemplate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Only mode with "single", "burst", "each", or "group".&#13;
     *                                 The returned pages will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to "false". In this case, the page will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one page and one page only.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "singleFileAsZip")
    protected Boolean singleFileAsZip;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the mode used to split the PDF document.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;last = Last page - Uses "pages" to define the last page that will be contained in the new PDF document.&lt;/li&gt;&lt;li&gt;first = First page - Uses "pages" to define the first page that will be contained in the new PDF document.&lt;/li&gt;&lt;li&gt;list = List of pages - Uses "pages" to define a list of pages that should be extracted from the document. A single PDF document will be created on the basis of this list.&lt;/li&gt;&lt;li&gt;single = Selected pages - Uses the "pages" attribute to define a list of pages that should be extracted from the document. And creates a ZIP file with the corresponding pages.&lt;/li&gt;&lt;li&gt;each = Every nth page - Uses the "pages" attribute to define the interval at which pages should be extracted. The "startPage" attribute is used to define the page on which the process will start. The result will be a ZIP file.&lt;/li&gt;&lt;li&gt;group = Group pages - Multiple pages will be added to a single PDF document. The "pages" attribute can be used to define how many pages will be saved in a single PDF document. The "startPage" attribute is used to define the page on which the process will start. The result will be a ZIP file.&lt;/li&gt;&lt;li&gt;burst = Ungroup pages - A new PDF document will be generated from each page. The result will be a ZIP file.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SplitModeType }
     *     
     */
    public SplitModeType getMode() {
        if (mode == null) {
            return SplitModeType.LAST;
        } else {
            return mode;
        }
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SplitModeType }
     *     
     * @see #getMode()
     */
    public void setMode(SplitModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which page(s) should be used for the split operation. The page number can be an individual page, a page range, or a list (separated with commas) (e.g. "1,5-6,9"). The "mode" attribute defines whether a single page or a range of pages can be used: With "last" and "first," an individual page is specified; with "list," a list of pages can be used.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "1";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used for "each" and "group" in the "mode" attribute.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getStartPage() {
        if (startPage == null) {
            return  1;
        } else {
            return startPage;
        }
    }

    /**
     * Sets the value of the startPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getStartPage()
     */
    public void setStartPage(int value) {
        this.startPage = value;
    }

    public boolean isSetStartPage() {
        return (this.startPage!= null);
    }

    public void unsetStartPage() {
        this.startPage = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the "split" operation generates a ZIP document (please refer to "mode"), this template can be used to define the file name of the PDF document in the ZIP document. The "%d" placeholder must be used in the template in order to define the PDF document page.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileNameTemplate() {
        if (fileNameTemplate == null) {
            return "page[%d]";
        } else {
            return fileNameTemplate;
        }
    }

    /**
     * Sets the value of the fileNameTemplate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFileNameTemplate()
     */
    public void setFileNameTemplate(String value) {
        this.fileNameTemplate = value;
    }

    public boolean isSetFileNameTemplate() {
        return (this.fileNameTemplate!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Only mode with "single", "burst", "each", or "group".&#13;
     *                                 The returned pages will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to "false". In this case, the page will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one page and one page only.&#13;
     *                             &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSingleFileAsZip() {
        if (singleFileAsZip == null) {
            return true;
        } else {
            return singleFileAsZip;
        }
    }

    /**
     * Sets the value of the singleFileAsZip property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSingleFileAsZip()
     */
    public void setSingleFileAsZip(boolean value) {
        this.singleFileAsZip = value;
    }

    public boolean isSetSingleFileAsZip() {
        return (this.singleFileAsZip!= null);
    }

    public void unsetSingleFileAsZip() {
        this.singleFileAsZip = null;
    }

}
