
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p31332_="https://jakarta.ee/xml/ns/jaxb" xmlns:p993856_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define an image, for the visual signature, that will be drawn in the signature's background. The image itself is passed with &lt;code&gt;&amp;lt;data&amp;gt;&lt;/code&gt;.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SignatureImageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SignatureImageType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}SignatureFileDataType"/>
 *       </all>
 *       <attribute name="opacity" default="50">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="position" default="center">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}SignatureImagePositionType">
 *             <enumeration value="center"/>
 *             <enumeration value="left"/>
 *             <enumeration value="right"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureImageType", propOrder = {

})
public class SignatureImageType {

    @XmlElement(required = true)
    protected SignatureFileDataType data;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p31332_="https://jakarta.ee/xml/ns/jaxb" xmlns:p993856_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Opacity of image as a percentage value between 0 and 100.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "opacity")
    protected Integer opacity;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p31332_="https://jakarta.ee/xml/ns/jaxb" xmlns:p993856_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Position of image within signature field:&#13;
     *                         &lt;ul&gt;&lt;li&gt;center = Centred&lt;/li&gt;&lt;li&gt;left = Left&lt;/li&gt;&lt;li&gt;right = Right&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "position")
    protected SignatureImagePositionType position;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureFileDataType }
     *     
     */
    public SignatureFileDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureFileDataType }
     *     
     */
    public void setData(SignatureFileDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p31332_="https://jakarta.ee/xml/ns/jaxb" xmlns:p993856_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Opacity of image as a percentage value between 0 and 100.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getOpacity() {
        if (opacity == null) {
            return  50;
        } else {
            return opacity;
        }
    }

    /**
     * Sets the value of the opacity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getOpacity()
     */
    public void setOpacity(int value) {
        this.opacity = value;
    }

    public boolean isSetOpacity() {
        return (this.opacity!= null);
    }

    public void unsetOpacity() {
        this.opacity = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p31332_="https://jakarta.ee/xml/ns/jaxb" xmlns:p993856_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Position of image within signature field:&#13;
     *                         &lt;ul&gt;&lt;li&gt;center = Centred&lt;/li&gt;&lt;li&gt;left = Left&lt;/li&gt;&lt;li&gt;right = Right&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SignatureImagePositionType }
     *     
     */
    public SignatureImagePositionType getPosition() {
        if (position == null) {
            return SignatureImagePositionType.CENTER;
        } else {
            return position;
        }
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureImagePositionType }
     *     
     * @see #getPosition()
     */
    public void setPosition(SignatureImagePositionType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

}
