
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows editing the content and properties of a textual reply to another annotation.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ReplyToAnnotationEditType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ReplyToAnnotationEditType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseReplyEditType">
 *       <all>
 *         <element name="objectKey">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *       <attribute name="comment" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="creator" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subject" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReplyToAnnotationEditType", propOrder = {
    "objectKey"
})
public class ReplyToAnnotationEditType
    extends BaseReplyEditType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the "reply to" annotation by object ID.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlElement(required = true)
    protected ReplyToAnnotationEditType.ObjectKey objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is used to set the textual comment/reply to display.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "comment")
    protected String comment;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the author of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "creator")
    protected String creator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the subject of the annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "subject")
    protected String subject;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page by page number, that shall contain the "reply to" annotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the "reply to" annotation by object ID.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ReplyToAnnotationEditType.ObjectKey }
     *     
     */
    public ReplyToAnnotationEditType.ObjectKey getObjectKey() {
        return objectKey;
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReplyToAnnotationEditType.ObjectKey }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(ReplyToAnnotationEditType.ObjectKey value) {
        this.objectKey = value;
    }

    public boolean isSetObjectKey() {
        return (this.objectKey!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is used to set the textual comment/reply to display.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getComment() {
        if (comment == null) {
            return "";
        } else {
            return comment;
        }
    }

    /**
     * Sets the value of the comment property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getComment()
     */
    public void setComment(String value) {
        this.comment = value;
    }

    public boolean isSetComment() {
        return (this.comment!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the author of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreator() {
        if (creator == null) {
            return "";
        } else {
            return creator;
        }
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreator()
     */
    public void setCreator(String value) {
        this.creator = value;
    }

    public boolean isSetCreator() {
        return (this.creator!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the subject of the annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubject() {
        if (subject == null) {
            return "";
        } else {
            return subject;
        }
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubject()
     */
    public void setSubject(String value) {
        this.subject = value;
    }

    public boolean isSetSubject() {
        return (this.subject!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the page by page number, that shall contain the "reply to" annotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class ObjectKey {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object id shall be given as a String that may contain either:&#13;
         *                                             &lt;ul&gt;&lt;li&gt;The numeric object ID itself&lt;/li&gt;&lt;li&gt;The object ID followed by the generation number, separated by a space&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "id")
        protected String id;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object id shall be given as a String that may contain either:&#13;
         *                                             &lt;ul&gt;&lt;li&gt;The numeric object ID itself&lt;/li&gt;&lt;li&gt;The object ID followed by the generation number, separated by a space&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getId() {
            if (id == null) {
                return "";
            } else {
                return id;
            }
        }

        /**
         * Sets the value of the id property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getId()
         */
        public void setId(String value) {
            this.id = value;
        }

        public boolean isSetId() {
            return (this.id!= null);
        }

    }

}
