
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p122528_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p474718_="https://jakarta.ee/xml/ns/jaxb" xmlns:p929760_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the language of the barcode's payment summary.&#13;
 *                     &lt;ul&gt;&lt;li&gt;de = german&lt;/li&gt;&lt;li&gt;fr = french&lt;/li&gt;&lt;li&gt;it = italian&lt;/li&gt;&lt;li&gt;en = english&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for QrSwissPaymentLanguageType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="QrSwissPaymentLanguageType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="de"/>
 *     <enumeration value="fr"/>
 *     <enumeration value="it"/>
 *     <enumeration value="en"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "QrSwissPaymentLanguageType")
@XmlEnum
public enum QrSwissPaymentLanguageType {

    @XmlEnumValue("de")
    DE("de"),
    @XmlEnumValue("fr")
    FR("fr"),
    @XmlEnumValue("it")
    IT("it"),
    @XmlEnumValue("en")
    EN("en");
    private final String value;

    QrSwissPaymentLanguageType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static QrSwissPaymentLanguageType fromValue(String v) {
        for (QrSwissPaymentLanguageType c: QrSwissPaymentLanguageType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
