
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The print operation element can be used to print documents.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PrintType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PrintType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <attribute name="printerName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="jobName" type="{http://www.w3.org/2001/XMLSchema}string" default="webPDF Print Job" />
 *       <attribute name="copies" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="autoRotate" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="shrinkToMargins" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="expandToMargins" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="centerInPage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="dpi" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="mode" type="{http://schema.webpdf.de/1.0/operation}PrintModeType" default="default" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PrintType")
public class PrintType
    extends BaseToolboxType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This attribute is used to specify the name of the printer that should be used to print the PDF document. If a printer is not declared, then the system's default printer will be used for printing.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "printerName")
    protected String printerName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which page(s) should be printed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This attribute is used to define the name of the print job (as shown in the Print Spooler in Windows, for example).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "jobName")
    protected String jobName;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the number of copies that should be printed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "copies")
    protected Integer copies;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the PDF document's orientation will be automatically adjusted in line with the printer's configured paper orientation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "autoRotate")
    protected Boolean autoRotate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," any PDF page that is larger than the paper will be shrunk to fit the paper size.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "shrinkToMargins")
    protected Boolean shrinkToMargins;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," any PDF page that is smaller than the paper will be enlarged to fit the paper size.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "expandToMargins")
    protected Boolean expandToMargins;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", the PDF page will be centered in the middle of the paper.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "centerInPage")
    protected Boolean centerInPage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the printer resolution for the "image" print mode. If this value is set to 0, the document will be printed, using a resolution suggested by the printer. (High resolutions will lead to better quality results, but will tremendously increase the required time and resources.)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dpi")
    protected Integer dpi;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select the printing mode, that shall be used.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;default = The drawing operations are applied to the printout as defined in the PDF document.&lt;/li&gt;&lt;li&gt;image = Creates an image of a fixed resolution for every page of the document, to guarantee a uniform printing result.&lt;/li&gt;&lt;li&gt;raster = Every page of the document is rastered before printing. This is a compatibility mode for older printers.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "mode")
    protected PrintModeType mode;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This attribute is used to specify the name of the printer that should be used to print the PDF document. If a printer is not declared, then the system's default printer will be used for printing.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPrinterName() {
        if (printerName == null) {
            return "";
        } else {
            return printerName;
        }
    }

    /**
     * Sets the value of the printerName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPrinterName()
     */
    public void setPrinterName(String value) {
        this.printerName = value;
    }

    public boolean isSetPrinterName() {
        return (this.printerName!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which page(s) should be printed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This attribute is used to define the name of the print job (as shown in the Print Spooler in Windows, for example).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobName() {
        if (jobName == null) {
            return "webPDF Print Job";
        } else {
            return jobName;
        }
    }

    /**
     * Sets the value of the jobName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getJobName()
     */
    public void setJobName(String value) {
        this.jobName = value;
    }

    public boolean isSetJobName() {
        return (this.jobName!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the number of copies that should be printed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getCopies() {
        if (copies == null) {
            return  1;
        } else {
            return copies;
        }
    }

    /**
     * Sets the value of the copies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getCopies()
     */
    public void setCopies(int value) {
        this.copies = value;
    }

    public boolean isSetCopies() {
        return (this.copies!= null);
    }

    public void unsetCopies() {
        this.copies = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the PDF document's orientation will be automatically adjusted in line with the printer's configured paper orientation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAutoRotate() {
        if (autoRotate == null) {
            return true;
        } else {
            return autoRotate;
        }
    }

    /**
     * Sets the value of the autoRotate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isAutoRotate()
     */
    public void setAutoRotate(boolean value) {
        this.autoRotate = value;
    }

    public boolean isSetAutoRotate() {
        return (this.autoRotate!= null);
    }

    public void unsetAutoRotate() {
        this.autoRotate = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," any PDF page that is larger than the paper will be shrunk to fit the paper size.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShrinkToMargins() {
        if (shrinkToMargins == null) {
            return false;
        } else {
            return shrinkToMargins;
        }
    }

    /**
     * Sets the value of the shrinkToMargins property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isShrinkToMargins()
     */
    public void setShrinkToMargins(boolean value) {
        this.shrinkToMargins = value;
    }

    public boolean isSetShrinkToMargins() {
        return (this.shrinkToMargins!= null);
    }

    public void unsetShrinkToMargins() {
        this.shrinkToMargins = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," any PDF page that is smaller than the paper will be enlarged to fit the paper size.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isExpandToMargins() {
        if (expandToMargins == null) {
            return false;
        } else {
            return expandToMargins;
        }
    }

    /**
     * Sets the value of the expandToMargins property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isExpandToMargins()
     */
    public void setExpandToMargins(boolean value) {
        this.expandToMargins = value;
    }

    public boolean isSetExpandToMargins() {
        return (this.expandToMargins!= null);
    }

    public void unsetExpandToMargins() {
        this.expandToMargins = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", the PDF page will be centered in the middle of the paper.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCenterInPage() {
        if (centerInPage == null) {
            return false;
        } else {
            return centerInPage;
        }
    }

    /**
     * Sets the value of the centerInPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCenterInPage()
     */
    public void setCenterInPage(boolean value) {
        this.centerInPage = value;
    }

    public boolean isSetCenterInPage() {
        return (this.centerInPage!= null);
    }

    public void unsetCenterInPage() {
        this.centerInPage = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the printer resolution for the "image" print mode. If this value is set to 0, the document will be printed, using a resolution suggested by the printer. (High resolutions will lead to better quality results, but will tremendously increase the required time and resources.)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDpi() {
        if (dpi == null) {
            return  0;
        } else {
            return dpi;
        }
    }

    /**
     * Sets the value of the dpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDpi()
     */
    public void setDpi(int value) {
        this.dpi = value;
    }

    public boolean isSetDpi() {
        return (this.dpi!= null);
    }

    public void unsetDpi() {
        this.dpi = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select the printing mode, that shall be used.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;default = The drawing operations are applied to the printout as defined in the PDF document.&lt;/li&gt;&lt;li&gt;image = Creates an image of a fixed resolution for every page of the document, to guarantee a uniform printing result.&lt;/li&gt;&lt;li&gt;raster = Every page of the document is rastered before printing. This is a compatibility mode for older printers.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PrintModeType }
     *     
     */
    public PrintModeType getMode() {
        if (mode == null) {
            return PrintModeType.DEFAULT;
        } else {
            return mode;
        }
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrintModeType }
     *     
     * @see #getMode()
     */
    public void setMode(PrintModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

}
