
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the box that should be scaled.&#13;
 *                     &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PageBoxType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PageBoxType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="media_box"/>
 *     <enumeration value="crop_box"/>
 *     <enumeration value="bleed_box"/>
 *     <enumeration value="trim_box"/>
 *     <enumeration value="art_box"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PageBoxType")
@XmlEnum
public enum PageBoxType {

    @XmlEnumValue("media_box")
    MEDIA_BOX("media_box"),
    @XmlEnumValue("crop_box")
    CROP_BOX("crop_box"),
    @XmlEnumValue("bleed_box")
    BLEED_BOX("bleed_box"),
    @XmlEnumValue("trim_box")
    TRIM_BOX("trim_box"),
    @XmlEnumValue("art_box")
    ART_BOX("art_box");
    private final String value;

    PageBoxType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PageBoxType fromValue(String v) {
        for (PageBoxType c: PageBoxType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
