
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p689949_="https://jakarta.ee/xml/ns/jaxb" xmlns:p832256_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.&#13;
 *                     &lt;ul&gt;&lt;li&gt;off = Do not apply this optimization&lt;/li&gt;&lt;li&gt;value = Select your own value&lt;/li&gt;&lt;li&gt;low = Apply optimization only with low intensity to avoid information loss.&lt;/li&gt;&lt;li&gt;medium = Perform optimization with medium intensity.&lt;/li&gt;&lt;li&gt;high = Perform optimization with strong intensity and accept possible information losses.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OptimizationIntensityType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="OptimizationIntensityType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="off"/>
 *     <enumeration value="value"/>
 *     <enumeration value="low"/>
 *     <enumeration value="medium"/>
 *     <enumeration value="high"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OptimizationIntensityType")
@XmlEnum
public enum OptimizationIntensityType {

    @XmlEnumValue("off")
    OFF("off"),
    @XmlEnumValue("value")
    VALUE("value"),
    @XmlEnumValue("low")
    LOW("low"),
    @XmlEnumValue("medium")
    MEDIUM("medium"),
    @XmlEnumValue("high")
    HIGH("high");
    private final String value;

    OptimizationIntensityType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static OptimizationIntensityType fromValue(String v) {
        for (OptimizationIntensityType c: OptimizationIntensityType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
