
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The executeNamed action executes a prepared action that is known to the reader application with a specific name. There are certain standard actions that should be known to any reader application. However, an application can have other defined names as well.&#13;
 *                     The actions' execution and what it does are defined exclusively by the reader application, meaning that the resulting behaviour can vary completely from one application to another.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for NamedActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="NamedActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <attribute name="namedOperation" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "NamedActionType")
public class NamedActionType
    extends ActionEventType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the action that should be run. The following are standard names that any reader application should know:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;NextPage = Jumps to the next page&lt;/li&gt;&lt;li&gt;PrevPage = Jumps to the previous page&lt;/li&gt;&lt;li&gt;FirstPage = Jump to the first page&lt;/li&gt;&lt;li&gt;LastPage = Jump to the last page&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "namedOperation")
    protected String namedOperation;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the action that should be run. The following are standard names that any reader application should know:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;NextPage = Jumps to the next page&lt;/li&gt;&lt;li&gt;PrevPage = Jumps to the previous page&lt;/li&gt;&lt;li&gt;FirstPage = Jump to the first page&lt;/li&gt;&lt;li&gt;LastPage = Jump to the last page&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamedOperation() {
        if (namedOperation == null) {
            return "";
        } else {
            return namedOperation;
        }
    }

    /**
     * Sets the value of the namedOperation property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getNamedOperation()
     */
    public void setNamedOperation(String value) {
        this.namedOperation = value;
    }

    public boolean isSetNamedOperation() {
        return (this.namedOperation!= null);
    }

}
