
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected page range should be inserted before or after the selected position in the document.&#13;
 *                     &lt;ul&gt;&lt;li&gt;afterPage = After the selected position.&lt;/li&gt;&lt;li&gt;beforePage = Before the selected position.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MoveModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="MoveModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="beforePage"/>
 *     <enumeration value="afterPage"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MoveModeType")
@XmlEnum
public enum MoveModeType {

    @XmlEnumValue("beforePage")
    BEFORE_PAGE("beforePage"),
    @XmlEnumValue("afterPage")
    AFTER_PAGE("afterPage");
    private final String value;

    MoveModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static MoveModeType fromValue(String v) {
        for (MoveModeType c: MoveModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
