
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An annotation that adds a textual comment directly to a page.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FreeTextAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FreeTextAnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseAnnotationType">
 *       <all>
 *         <element name="font" type="{http://schema.webpdf.de/1.0/operation}FreeTextFontType" minOccurs="0"/>
 *         <element name="position" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice minOccurs="0">
 *                   <element name="rectangle" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *       <attribute name="justification" type="{http://schema.webpdf.de/1.0/operation}JustificationType" default="leftJustified" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FreeTextAnnotationType", propOrder = {
    "font",
    "position"
})
public class FreeTextAnnotationType
    extends BaseAnnotationType
{

    protected FreeTextFontType font;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     */
    protected FreeTextAnnotationType.Position position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the horizontal justification/alignment/orientation of elements.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;leftJustified = All elements shall be oriented to the left.&lt;/li&gt;&lt;li&gt;centered = All elements shall be placed in the center of the container.&lt;/li&gt;&lt;li&gt;rightJustified = All elements shall be oriented to the right.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "justification")
    protected JustificationType justification;

    /**
     * Gets the value of the font property.
     * 
     * @return
     *     possible object is
     *     {@link FreeTextFontType }
     *     
     */
    public FreeTextFontType getFont() {
        return font;
    }

    /**
     * Sets the value of the font property.
     * 
     * @param value
     *     allowed object is
     *     {@link FreeTextFontType }
     *     
     */
    public void setFont(FreeTextFontType value) {
        this.font = value;
    }

    public boolean isSetFont() {
        return (this.font!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the bounds within which the shape shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FreeTextAnnotationType.Position }
     *     
     */
    public FreeTextAnnotationType.Position getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link FreeTextAnnotationType.Position }
     *     
     * @see #getPosition()
     */
    public void setPosition(FreeTextAnnotationType.Position value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the horizontal justification/alignment/orientation of elements.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;leftJustified = All elements shall be oriented to the left.&lt;/li&gt;&lt;li&gt;centered = All elements shall be placed in the center of the container.&lt;/li&gt;&lt;li&gt;rightJustified = All elements shall be oriented to the right.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link JustificationType }
     *     
     */
    public JustificationType getJustification() {
        if (justification == null) {
            return JustificationType.LEFT_JUSTIFIED;
        } else {
            return justification;
        }
    }

    /**
     * Sets the value of the justification property.
     * 
     * @param value
     *     allowed object is
     *     {@link JustificationType }
     *     
     * @see #getJustification()
     */
    public void setJustification(JustificationType value) {
        this.justification = value;
    }

    public boolean isSetJustification() {
        return (this.justification!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice minOccurs="0">
     *         <element name="rectangle" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "rectangle"
    })
    public static class Position {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select an unrotated rectangular position.&lt;/p&gt;
         * </pre>
         * 
         */
        protected RectangleType rectangle;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p478056_="https://jakarta.ee/xml/ns/jaxb" xmlns:p587657_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p878301_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select an unrotated rectangular position.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link RectangleType }
         *     
         */
        public RectangleType getRectangle() {
            return rectangle;
        }

        /**
         * Sets the value of the rectangle property.
         * 
         * @param value
         *     allowed object is
         *     {@link RectangleType }
         *     
         * @see #getRectangle()
         */
        public void setRectangle(RectangleType value) {
            this.rectangle = value;
        }

        public boolean isSetRectangle() {
            return (this.rectangle!= null);
        }

    }

}
