
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter determines at which error level the conversion should fail, you can use this parameter to automatically reject also results with lower precision as failure&#13;
 *                     &lt;ul&gt;&lt;li&gt;warning = Documents for which warnings occur will also cause the conversion to fail.&lt;/li&gt;&lt;li&gt;missingContent = Documents for which not all content could be converted correctly will also be considered as failures.&lt;/li&gt;&lt;li&gt;error = Only if a conversion of the document did not lead to any meaningful result document, this is evaluated as failure, even if contents should be missing.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for FailureType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="FailureType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="warning"/>
 *     <enumeration value="missingContent"/>
 *     <enumeration value="error"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FailureType")
@XmlEnum
public enum FailureType {

    @XmlEnumValue("warning")
    WARNING("warning"),
    @XmlEnumValue("missingContent")
    MISSING_CONTENT("missingContent"),
    @XmlEnumValue("error")
    ERROR("error");
    private final String value;

    FailureType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static FailureType fromValue(String v) {
        for (FailureType c: FailureType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
