
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Extract links from thePDF document&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Generates an ASCII text, XML, or JSON file that will be returned as a result when the web service is called and that will contain all selected supported links in the PDF document. Every link is written to a separate line in the ASCII file.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ExtractionLinksType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ExtractionLinksType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseExtractionType">
 *       <all>
 *         <element name="text" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="fromText" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *                 <attribute name="protocol" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="withoutProtocol" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExtractionLinksType", propOrder = {
    "text"
})
public class ExtractionLinksType
    extends BaseExtractionType
{

    protected ExtractionLinksType.Text text;

    /**
     * Gets the value of the text property.
     * 
     * @return
     *     possible object is
     *     {@link ExtractionLinksType.Text }
     *     
     */
    public ExtractionLinksType.Text getText() {
        return text;
    }

    /**
     * Sets the value of the text property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtractionLinksType.Text }
     *     
     */
    public void setText(ExtractionLinksType.Text value) {
        this.text = value;
    }

    public boolean isSetText() {
        return (this.text!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="fromText" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
     *       <attribute name="protocol" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="withoutProtocol" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Text {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Advanced mode for extracting links When using this mode, links will not be extracted from annotations, but will instead be extracted directly from the text. This means that links that are not found in standard mode can be found with this advanced mode, provided that they are present in the form of text.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "fromText")
        protected Boolean fromText;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Provides the option of filtering the links being extracted by protocol. If multiple protocols are specified, they need to be separated with commas (e.g., "http,https,ftp"). The following values are valid: "http","https","ftp", "telnet","mailto", "file", "nntp", and "notes".&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "protocol")
        protected String protocol;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When enabled, incomplete URLs from which the protocol information is missing will be extracted as well when extracting links from text. This would apply to the following examples, for instance:&#13;
         *                                             &lt;ul&gt;&lt;li&gt;"www.webpdf.de" - There is no protocol information. If the option is enabled and "http" links are searched for, the link will be extracted.&lt;/li&gt;&lt;li&gt;"ftp.softvision.de" - There is no protocol information here either. If the option is enabled and "ftp" links are searched for, the link will be extracted.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "withoutProtocol")
        protected Boolean withoutProtocol;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Advanced mode for extracting links When using this mode, links will not be extracted from annotations, but will instead be extracted directly from the text. This means that links that are not found in standard mode can be found with this advanced mode, provided that they are present in the form of text.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isFromText() {
            if (fromText == null) {
                return false;
            } else {
                return fromText;
            }
        }

        /**
         * Sets the value of the fromText property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isFromText()
         */
        public void setFromText(boolean value) {
            this.fromText = value;
        }

        public boolean isSetFromText() {
            return (this.fromText!= null);
        }

        public void unsetFromText() {
            this.fromText = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Provides the option of filtering the links being extracted by protocol. If multiple protocols are specified, they need to be separated with commas (e.g., "http,https,ftp"). The following values are valid: "http","https","ftp", "telnet","mailto", "file", "nntp", and "notes".&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getProtocol() {
            if (protocol == null) {
                return "";
            } else {
                return protocol;
            }
        }

        /**
         * Sets the value of the protocol property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getProtocol()
         */
        public void setProtocol(String value) {
            this.protocol = value;
        }

        public boolean isSetProtocol() {
            return (this.protocol!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When enabled, incomplete URLs from which the protocol information is missing will be extracted as well when extracting links from text. This would apply to the following examples, for instance:&#13;
         *                                             &lt;ul&gt;&lt;li&gt;"www.webpdf.de" - There is no protocol information. If the option is enabled and "http" links are searched for, the link will be extracted.&lt;/li&gt;&lt;li&gt;"ftp.softvision.de" - There is no protocol information here either. If the option is enabled and "ftp" links are searched for, the link will be extracted.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isWithoutProtocol() {
            if (withoutProtocol == null) {
                return true;
            } else {
                return withoutProtocol;
            }
        }

        /**
         * Sets the value of the withoutProtocol property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isWithoutProtocol()
         */
        public void setWithoutProtocol(boolean value) {
            this.withoutProtocol = value;
        }

        public boolean isSetWithoutProtocol() {
            return (this.withoutProtocol!= null);
        }

        public void unsetWithoutProtocol() {
            this.withoutProtocol = null;
        }

    }

}
