
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the output format for the PDF document text contents being extracted.&#13;
 *                     &lt;ul&gt;&lt;li&gt;text = Text document&lt;/li&gt;&lt;li&gt;xml = XML document&lt;/li&gt;&lt;li&gt;json = JSON data structure&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ExtractionFileFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="ExtractionFileFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="text"/>
 *     <enumeration value="xml"/>
 *     <enumeration value="json"/>
 *     <enumeration value="zip"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ExtractionFileFormatType")
@XmlEnum
public enum ExtractionFileFormatType {

    @XmlEnumValue("text")
    TEXT("text"),
    @XmlEnumValue("xml")
    XML("xml"),
    @XmlEnumValue("json")
    JSON("json"),
    @XmlEnumValue("zip")
    ZIP("zip");
    private final String value;

    ExtractionFileFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static ExtractionFileFormatType fromValue(String v) {
        for (ExtractionFileFormatType c: ExtractionFileFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
