
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Performs the conversion of a document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ConverterType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ConverterType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="page" type="{http://schema.webpdf.de/1.0/operation}ConverterPageType" minOccurs="0"/>
 *         <element name="pdfa" type="{http://schema.webpdf.de/1.0/operation}PdfaType" minOccurs="0"/>
 *         <element name="signature" type="{http://schema.webpdf.de/1.0/operation}SignatureType" minOccurs="0"/>
 *         <element name="html" type="{http://schema.webpdf.de/1.0/operation}ConverterHtmlType" minOccurs="0"/>
 *         <element name="mail" type="{http://schema.webpdf.de/1.0/operation}ConverterMailType" minOccurs="0"/>
 *         <element name="officeBridge" type="{http://schema.webpdf.de/1.0/operation}OfficeBridgeType" minOccurs="0"/>
 *         <element name="sharePointBridge" type="{http://schema.webpdf.de/1.0/operation}SharePointBridgeType" minOccurs="0"/>
 *         <element name="report" type="{http://schema.webpdf.de/1.0/operation}ConverterReportType" minOccurs="0"/>
 *         <element name="template" type="{http://schema.webpdf.de/1.0/operation}ConverterTemplateType" minOccurs="0"/>
 *         <element name="text" type="{http://schema.webpdf.de/1.0/operation}ConverterTextType" minOccurs="0"/>
 *         <element name="transform" type="{http://schema.webpdf.de/1.0/operation}ConverterTransformType" minOccurs="0"/>
 *         <element name="image" type="{http://schema.webpdf.de/1.0/operation}ConverterImageType" minOccurs="0"/>
 *         <element name="office" type="{http://schema.webpdf.de/1.0/operation}ConverterOfficeType" minOccurs="0"/>
 *       </all>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="compression" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="jpegQuality" default="90">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="reduceResolution" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="dpi" default="300">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}DpiType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="embedFonts" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="accessPassword" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="fileExtension" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="maxRecursion" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConverterType", propOrder = {

})
public class ConverterType
    implements ParameterInterface
{

    protected ConverterPageType page;
    protected PdfaType pdfa;
    protected SignatureType signature;
    protected ConverterHtmlType html;
    protected ConverterMailType mail;
    protected OfficeBridgeType officeBridge;
    protected SharePointBridgeType sharePointBridge;
    protected ConverterReportType report;
    protected ConverterTemplateType template;
    protected ConverterTextType text;
    protected ConverterTransformType transform;
    protected ConverterImageType image;
    protected ConverterOfficeType office;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A text that defines the page range for the export. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: "1-10" or "1,2,5-10")&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the data objects in the PDF document will be compressed (ZLib compression), reducing the size of the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "compression")
    protected Boolean compression;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the quality (as a percentage) of JPEG images in the PDF document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "jpegQuality")
    protected Integer jpegQuality;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," then the DPI resolution of graphics is reduced. The reduction value is set with "dpi."&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "reduceResolution")
    protected Boolean reduceResolution;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the DPI solution (pixels per inch) for images.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dpi")
    protected Integer dpi;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," fonts will be embedded in the PDF document that is created.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;: If the original fonts are not available on the conversion system, substitute fonts may be embedded instead.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;: If, after the conversion, you want to convert the PDF document to PDF/A, you should not embed any of the fonts, but should instead let the "Pdfa" web service do this.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "embedFonts")
    protected Boolean embedFonts;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter can be used to declare a password that will be used to open the source document if it is protected.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         This option is currently only supported for Microsoft Office 97-2003 binary documents and Microsoft Office 2007 documents. Only the default password methods are supported. Encryption based on digital certificates is not supported.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "accessPassword")
    protected String accessPassword;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If you use this attribute to enter an extension for the file (e.g., "doc") that is currently being processed, automatic file format detection will be disabled. Normally, webPDF does not detect file formats based on the corresponding file extension, but on the file contents instead. Accordingly, webPDF will analyze the file and assign the file the appropriate "mime-type" so that the appropriate file converter can then be selected.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;: You should only set a file extension in exceptional cases, as this will completely disable automatic detection. If, for instance, you specify an extension for which webPDF does not have a "mime-type," the conversion will fail.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "fileExtension")
    protected String fileExtension;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the maximum recursions, that may occur when converting a document's attachments.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         This parameter is intended for internal use only. Please only use this, if you really are sure you need to do so.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "maxRecursion")
    protected Integer maxRecursion;

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterPageType }
     *     
     */
    public ConverterPageType getPage() {
        return page;
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterPageType }
     *     
     */
    public void setPage(ConverterPageType value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    /**
     * Gets the value of the pdfa property.
     * 
     * @return
     *     possible object is
     *     {@link PdfaType }
     *     
     */
    public PdfaType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType }
     *     
     */
    public void setPdfa(PdfaType value) {
        this.pdfa = value;
    }

    public boolean isSetPdfa() {
        return (this.pdfa!= null);
    }

    /**
     * Gets the value of the signature property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureType }
     *     
     */
    public SignatureType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType }
     *     
     */
    public void setSignature(SignatureType value) {
        this.signature = value;
    }

    public boolean isSetSignature() {
        return (this.signature!= null);
    }

    /**
     * Gets the value of the html property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterHtmlType }
     *     
     */
    public ConverterHtmlType getHtml() {
        return html;
    }

    /**
     * Sets the value of the html property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterHtmlType }
     *     
     */
    public void setHtml(ConverterHtmlType value) {
        this.html = value;
    }

    public boolean isSetHtml() {
        return (this.html!= null);
    }

    /**
     * Gets the value of the mail property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterMailType }
     *     
     */
    public ConverterMailType getMail() {
        return mail;
    }

    /**
     * Sets the value of the mail property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterMailType }
     *     
     */
    public void setMail(ConverterMailType value) {
        this.mail = value;
    }

    public boolean isSetMail() {
        return (this.mail!= null);
    }

    /**
     * Gets the value of the officeBridge property.
     * 
     * @return
     *     possible object is
     *     {@link OfficeBridgeType }
     *     
     */
    public OfficeBridgeType getOfficeBridge() {
        return officeBridge;
    }

    /**
     * Sets the value of the officeBridge property.
     * 
     * @param value
     *     allowed object is
     *     {@link OfficeBridgeType }
     *     
     */
    public void setOfficeBridge(OfficeBridgeType value) {
        this.officeBridge = value;
    }

    public boolean isSetOfficeBridge() {
        return (this.officeBridge!= null);
    }

    /**
     * Gets the value of the sharePointBridge property.
     * 
     * @return
     *     possible object is
     *     {@link SharePointBridgeType }
     *     
     */
    public SharePointBridgeType getSharePointBridge() {
        return sharePointBridge;
    }

    /**
     * Sets the value of the sharePointBridge property.
     * 
     * @param value
     *     allowed object is
     *     {@link SharePointBridgeType }
     *     
     */
    public void setSharePointBridge(SharePointBridgeType value) {
        this.sharePointBridge = value;
    }

    public boolean isSetSharePointBridge() {
        return (this.sharePointBridge!= null);
    }

    /**
     * Gets the value of the report property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterReportType }
     *     
     */
    public ConverterReportType getReport() {
        return report;
    }

    /**
     * Sets the value of the report property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterReportType }
     *     
     */
    public void setReport(ConverterReportType value) {
        this.report = value;
    }

    public boolean isSetReport() {
        return (this.report!= null);
    }

    /**
     * Gets the value of the template property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterTemplateType }
     *     
     */
    public ConverterTemplateType getTemplate() {
        return template;
    }

    /**
     * Sets the value of the template property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterTemplateType }
     *     
     */
    public void setTemplate(ConverterTemplateType value) {
        this.template = value;
    }

    public boolean isSetTemplate() {
        return (this.template!= null);
    }

    /**
     * Gets the value of the text property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterTextType }
     *     
     */
    public ConverterTextType getText() {
        return text;
    }

    /**
     * Sets the value of the text property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterTextType }
     *     
     */
    public void setText(ConverterTextType value) {
        this.text = value;
    }

    public boolean isSetText() {
        return (this.text!= null);
    }

    /**
     * Gets the value of the transform property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterTransformType }
     *     
     */
    public ConverterTransformType getTransform() {
        return transform;
    }

    /**
     * Sets the value of the transform property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterTransformType }
     *     
     */
    public void setTransform(ConverterTransformType value) {
        this.transform = value;
    }

    public boolean isSetTransform() {
        return (this.transform!= null);
    }

    /**
     * Gets the value of the image property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterImageType }
     *     
     */
    public ConverterImageType getImage() {
        return image;
    }

    /**
     * Sets the value of the image property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterImageType }
     *     
     */
    public void setImage(ConverterImageType value) {
        this.image = value;
    }

    public boolean isSetImage() {
        return (this.image!= null);
    }

    /**
     * Gets the value of the office property.
     * 
     * @return
     *     possible object is
     *     {@link ConverterOfficeType }
     *     
     */
    public ConverterOfficeType getOffice() {
        return office;
    }

    /**
     * Sets the value of the office property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConverterOfficeType }
     *     
     */
    public void setOffice(ConverterOfficeType value) {
        this.office = value;
    }

    public boolean isSetOffice() {
        return (this.office!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A text that defines the page range for the export. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: "1-10" or "1,2,5-10")&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the data objects in the PDF document will be compressed (ZLib compression), reducing the size of the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCompression() {
        if (compression == null) {
            return true;
        } else {
            return compression;
        }
    }

    /**
     * Sets the value of the compression property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCompression()
     */
    public void setCompression(boolean value) {
        this.compression = value;
    }

    public boolean isSetCompression() {
        return (this.compression!= null);
    }

    public void unsetCompression() {
        this.compression = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the quality (as a percentage) of JPEG images in the PDF document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getJpegQuality() {
        if (jpegQuality == null) {
            return  90;
        } else {
            return jpegQuality;
        }
    }

    /**
     * Sets the value of the jpegQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getJpegQuality()
     */
    public void setJpegQuality(int value) {
        this.jpegQuality = value;
    }

    public boolean isSetJpegQuality() {
        return (this.jpegQuality!= null);
    }

    public void unsetJpegQuality() {
        this.jpegQuality = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," then the DPI resolution of graphics is reduced. The reduction value is set with "dpi."&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isReduceResolution() {
        if (reduceResolution == null) {
            return false;
        } else {
            return reduceResolution;
        }
    }

    /**
     * Sets the value of the reduceResolution property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isReduceResolution()
     */
    public void setReduceResolution(boolean value) {
        this.reduceResolution = value;
    }

    public boolean isSetReduceResolution() {
        return (this.reduceResolution!= null);
    }

    public void unsetReduceResolution() {
        this.reduceResolution = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the DPI solution (pixels per inch) for images.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDpi() {
        if (dpi == null) {
            return  300;
        } else {
            return dpi;
        }
    }

    /**
     * Sets the value of the dpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDpi()
     */
    public void setDpi(int value) {
        this.dpi = value;
    }

    public boolean isSetDpi() {
        return (this.dpi!= null);
    }

    public void unsetDpi() {
        this.dpi = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," fonts will be embedded in the PDF document that is created.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;: If the original fonts are not available on the conversion system, substitute fonts may be embedded instead.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;: If, after the conversion, you want to convert the PDF document to PDF/A, you should not embed any of the fonts, but should instead let the "Pdfa" web service do this.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEmbedFonts() {
        if (embedFonts == null) {
            return false;
        } else {
            return embedFonts;
        }
    }

    /**
     * Sets the value of the embedFonts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isEmbedFonts()
     */
    public void setEmbedFonts(boolean value) {
        this.embedFonts = value;
    }

    public boolean isSetEmbedFonts() {
        return (this.embedFonts!= null);
    }

    public void unsetEmbedFonts() {
        this.embedFonts = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter can be used to declare a password that will be used to open the source document if it is protected.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         This option is currently only supported for Microsoft Office 97-2003 binary documents and Microsoft Office 2007 documents. Only the default password methods are supported. Encryption based on digital certificates is not supported.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccessPassword() {
        if (accessPassword == null) {
            return "";
        } else {
            return accessPassword;
        }
    }

    /**
     * Sets the value of the accessPassword property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getAccessPassword()
     */
    public void setAccessPassword(String value) {
        this.accessPassword = value;
    }

    public boolean isSetAccessPassword() {
        return (this.accessPassword!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If you use this attribute to enter an extension for the file (e.g., "doc") that is currently being processed, automatic file format detection will be disabled. Normally, webPDF does not detect file formats based on the corresponding file extension, but on the file contents instead. Accordingly, webPDF will analyze the file and assign the file the appropriate "mime-type" so that the appropriate file converter can then be selected.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;: You should only set a file extension in exceptional cases, as this will completely disable automatic detection. If, for instance, you specify an extension for which webPDF does not have a "mime-type," the conversion will fail.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileExtension() {
        if (fileExtension == null) {
            return "";
        } else {
            return fileExtension;
        }
    }

    /**
     * Sets the value of the fileExtension property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFileExtension()
     */
    public void setFileExtension(String value) {
        this.fileExtension = value;
    }

    public boolean isSetFileExtension() {
        return (this.fileExtension!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the maximum recursions, that may occur when converting a document's attachments.&lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         This parameter is intended for internal use only. Please only use this, if you really are sure you need to do so.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMaxRecursion() {
        if (maxRecursion == null) {
            return  1;
        } else {
            return maxRecursion;
        }
    }

    /**
     * Sets the value of the maxRecursion property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getMaxRecursion()
     */
    public void setMaxRecursion(int value) {
        this.maxRecursion = value;
    }

    public boolean isSetMaxRecursion() {
        return (this.maxRecursion!= null);
    }

    public void unsetMaxRecursion() {
        this.maxRecursion = null;
    }

}
