
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Combines object definitions of the document into so-called "object streams" and compresses them. This operation is recommended especially for larger documents with many objects. The size of contained resources (such as graphics and fonts) cannot be reduced in this way.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for CompressObjectsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CompressObjectsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="objectStreamSize" default="200">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CompressObjectsType")
public class CompressObjectsType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the number of objects that may be combined into one stream. The higher the number, the higher the expected effect (assuming that the document contains a large number of objects). On the other hand, very large object streams can have a negative effect on the loading and display speed of the document in readers. For values beyond 500 objects, it is recommended to perform a manual check whether the document can still be displayed without problems.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "objectStreamSize")
    protected Integer objectStreamSize;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the number of objects that may be combined into one stream. The higher the number, the higher the expected effect (assuming that the document contains a large number of objects). On the other hand, very large object streams can have a negative effect on the loading and display speed of the document in readers. For values beyond 500 objects, it is recommended to perform a manual check whether the document can still be displayed without problems.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getObjectStreamSize() {
        if (objectStreamSize == null) {
            return  200;
        } else {
            return objectStreamSize;
        }
    }

    /**
     * Sets the value of the objectStreamSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getObjectStreamSize()
     */
    public void setObjectStreamSize(int value) {
        this.objectStreamSize = value;
    }

    public boolean isSetObjectStreamSize() {
        return (this.objectStreamSize!= null);
    }

    public void unsetObjectStreamSize() {
        this.objectStreamSize = null;
    }

}
