
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p31332_="https://jakarta.ee/xml/ns/jaxb" xmlns:p993856_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter defines the level of the signature.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = Sign, but do not certify, the document, i.e., additional signatures and changes will be allowed.&lt;/li&gt;&lt;li&gt;noChanges = Certify the document and do not allow any additional changes anymore.&lt;/li&gt;&lt;li&gt;formFillingAndSignatures = Certify the document, but allow for fields to be filled out.&lt;/li&gt;&lt;li&gt;formFillingAndSignaturesAndAnnotations = Certify the document, but allow for fields to be filled out and annotations to be added.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for CertificationLevelType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="CertificationLevelType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="noChanges"/>
 *     <enumeration value="formFillingAndSignatures"/>
 *     <enumeration value="formFillingAndSignaturesAndAnnotations"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "CertificationLevelType")
@XmlEnum
public enum CertificationLevelType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("noChanges")
    NO_CHANGES("noChanges"),
    @XmlEnumValue("formFillingAndSignatures")
    FORM_FILLING_AND_SIGNATURES("formFillingAndSignatures"),
    @XmlEnumValue("formFillingAndSignaturesAndAnnotations")
    FORM_FILLING_AND_SIGNATURES_AND_ANNOTATIONS("formFillingAndSignaturesAndAnnotations");
    private final String value;

    CertificationLevelType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static CertificationLevelType fromValue(String v) {
        for (CertificationLevelType c: CertificationLevelType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
