
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this element is set, all redact annotations placed in the document will be converted into actual content redactions. Content obscured by such an annotation will be irretrievably removed from the page content.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BlackenType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BlackenType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="collisionRatio" default="30">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <maxInclusive value="100"/>
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="redactTexts" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="redactImages" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="redactAnnotations" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="redactPaths" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BlackenType")
public class BlackenType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies a percentage value by which a letter must be obscured at least to be considered blackened and thus removed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "collisionRatio")
    protected Integer collisionRatio;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", all texts are blackened letter by letter.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "redactTexts")
    protected Boolean redactTexts;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, all blackened image data will be removed. For images, the entire image is not removed, but the obscured area is replaced by the redaction.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "redactImages")
    protected Boolean redactImages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", all blackened annotations will be removed. Annotations are removed completely even if they are only truncated.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "redactAnnotations")
    protected Boolean redactAnnotations;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, all blackened character paths are removed. The paths are adjusted so that the blackened section is removed from the path construction.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "redactPaths")
    protected Boolean redactPaths;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies a percentage value by which a letter must be obscured at least to be considered blackened and thus removed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getCollisionRatio() {
        if (collisionRatio == null) {
            return  30;
        } else {
            return collisionRatio;
        }
    }

    /**
     * Sets the value of the collisionRatio property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getCollisionRatio()
     */
    public void setCollisionRatio(int value) {
        this.collisionRatio = value;
    }

    public boolean isSetCollisionRatio() {
        return (this.collisionRatio!= null);
    }

    public void unsetCollisionRatio() {
        this.collisionRatio = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", all texts are blackened letter by letter.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRedactTexts() {
        if (redactTexts == null) {
            return true;
        } else {
            return redactTexts;
        }
    }

    /**
     * Sets the value of the redactTexts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRedactTexts()
     */
    public void setRedactTexts(boolean value) {
        this.redactTexts = value;
    }

    public boolean isSetRedactTexts() {
        return (this.redactTexts!= null);
    }

    public void unsetRedactTexts() {
        this.redactTexts = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, all blackened image data will be removed. For images, the entire image is not removed, but the obscured area is replaced by the redaction.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRedactImages() {
        if (redactImages == null) {
            return true;
        } else {
            return redactImages;
        }
    }

    /**
     * Sets the value of the redactImages property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRedactImages()
     */
    public void setRedactImages(boolean value) {
        this.redactImages = value;
    }

    public boolean isSetRedactImages() {
        return (this.redactImages!= null);
    }

    public void unsetRedactImages() {
        this.redactImages = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to "true", all blackened annotations will be removed. Annotations are removed completely even if they are only truncated.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRedactAnnotations() {
        if (redactAnnotations == null) {
            return true;
        } else {
            return redactAnnotations;
        }
    }

    /**
     * Sets the value of the redactAnnotations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRedactAnnotations()
     */
    public void setRedactAnnotations(boolean value) {
        this.redactAnnotations = value;
    }

    public boolean isSetRedactAnnotations() {
        return (this.redactAnnotations!= null);
    }

    public void unsetRedactAnnotations() {
        this.redactAnnotations = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, all blackened character paths are removed. The paths are adjusted so that the blackened section is removed from the path construction.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRedactPaths() {
        if (redactPaths == null) {
            return true;
        } else {
            return redactPaths;
        }
    }

    /**
     * Sets the value of the redactPaths property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRedactPaths()
     */
    public void setRedactPaths(boolean value) {
        this.redactPaths = value;
    }

    public boolean isSetRedactPaths() {
        return (this.redactPaths!= null);
    }

    public void unsetRedactPaths() {
        this.redactPaths = null;
    }

}
