
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines basic configuration settings for generating background layers.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BackgroundBaseSettingsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BackgroundBaseSettingsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="position" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="x" default="0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="y" default="0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="mm" />
 *                 <attribute name="position" type="{http://schema.webpdf.de/1.0/operation}BackgroundPositionModeType" default="center_center" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="visibility" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="onPrint" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *                 <attribute name="onScreen" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="pages" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="pageInterval" type="{http://schema.webpdf.de/1.0/operation}PageIntervalType" minOccurs="0"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}BaseBackgroundGroup"/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BackgroundBaseSettingsType", propOrder = {

})
public class BackgroundBaseSettingsType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the position of the background layer.&lt;/p&gt;
     * </pre>
     * 
     */
    protected BackgroundBaseSettingsType.Position position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the element's visibility in various use contexts.&lt;/p&gt;
     * </pre>
     * 
     */
    protected BackgroundBaseSettingsType.Visibility visibility;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the pages to which backgrounds shall be applied.&lt;/p&gt;
     * </pre>
     * 
     */
    protected BackgroundBaseSettingsType.Pages pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the background layer will not be scaled relative to its own original size, but rather to the dimensions of the page containing it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "relativeToPage")
    protected Boolean relativeToPage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, an existing background layer will be automatically deleted and replaced with the new one. If false, an existing background layer will cause the operation to be aborted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "replaceExisting")
    protected Boolean replaceExisting;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A percentage value used to specify the scaling for the background layer. This scaling can either be relative to the background layer's original size or to the dimensions of the page containing it (depends on the "relativeToPage" parameter)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "scale")
    protected Integer scale;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A value between 0 and 360 degrees that is used to specify the background layer's rotation.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "rotation")
    protected Integer rotation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A percentage value that is used to specify the background layer's transparency (100 percent means fully visible).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "opacity")
    protected Integer opacity;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the position of the background layer.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BackgroundBaseSettingsType.Position }
     *     
     */
    public BackgroundBaseSettingsType.Position getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link BackgroundBaseSettingsType.Position }
     *     
     * @see #getPosition()
     */
    public void setPosition(BackgroundBaseSettingsType.Position value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the element's visibility in various use contexts.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BackgroundBaseSettingsType.Visibility }
     *     
     */
    public BackgroundBaseSettingsType.Visibility getVisibility() {
        return visibility;
    }

    /**
     * Sets the value of the visibility property.
     * 
     * @param value
     *     allowed object is
     *     {@link BackgroundBaseSettingsType.Visibility }
     *     
     * @see #getVisibility()
     */
    public void setVisibility(BackgroundBaseSettingsType.Visibility value) {
        this.visibility = value;
    }

    public boolean isSetVisibility() {
        return (this.visibility!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the pages to which backgrounds shall be applied.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BackgroundBaseSettingsType.Pages }
     *     
     */
    public BackgroundBaseSettingsType.Pages getPages() {
        return pages;
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link BackgroundBaseSettingsType.Pages }
     *     
     * @see #getPages()
     */
    public void setPages(BackgroundBaseSettingsType.Pages value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the background layer will not be scaled relative to its own original size, but rather to the dimensions of the page containing it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRelativeToPage() {
        if (relativeToPage == null) {
            return true;
        } else {
            return relativeToPage;
        }
    }

    /**
     * Sets the value of the relativeToPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRelativeToPage()
     */
    public void setRelativeToPage(boolean value) {
        this.relativeToPage = value;
    }

    public boolean isSetRelativeToPage() {
        return (this.relativeToPage!= null);
    }

    public void unsetRelativeToPage() {
        this.relativeToPage = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, an existing background layer will be automatically deleted and replaced with the new one. If false, an existing background layer will cause the operation to be aborted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isReplaceExisting() {
        if (replaceExisting == null) {
            return false;
        } else {
            return replaceExisting;
        }
    }

    /**
     * Sets the value of the replaceExisting property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isReplaceExisting()
     */
    public void setReplaceExisting(boolean value) {
        this.replaceExisting = value;
    }

    public boolean isSetReplaceExisting() {
        return (this.replaceExisting!= null);
    }

    public void unsetReplaceExisting() {
        this.replaceExisting = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A percentage value used to specify the scaling for the background layer. This scaling can either be relative to the background layer's original size or to the dimensions of the page containing it (depends on the "relativeToPage" parameter)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getScale() {
        if (scale == null) {
            return  100;
        } else {
            return scale;
        }
    }

    /**
     * Sets the value of the scale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getScale()
     */
    public void setScale(int value) {
        this.scale = value;
    }

    public boolean isSetScale() {
        return (this.scale!= null);
    }

    public void unsetScale() {
        this.scale = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A value between 0 and 360 degrees that is used to specify the background layer's rotation.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getRotation() {
        if (rotation == null) {
            return  0;
        } else {
            return rotation;
        }
    }

    /**
     * Sets the value of the rotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getRotation()
     */
    public void setRotation(int value) {
        this.rotation = value;
    }

    public boolean isSetRotation() {
        return (this.rotation!= null);
    }

    public void unsetRotation() {
        this.rotation = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A percentage value that is used to specify the background layer's transparency (100 percent means fully visible).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getOpacity() {
        if (opacity == null) {
            return  100;
        } else {
            return opacity;
        }
    }

    /**
     * Sets the value of the opacity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getOpacity()
     */
    public void setOpacity(int value) {
        this.opacity = value;
    }

    public boolean isSetOpacity() {
        return (this.opacity!= null);
    }

    public void unsetOpacity() {
        this.opacity = null;
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="pageInterval" type="{http://schema.webpdf.de/1.0/operation}PageIntervalType" minOccurs="0"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "pageInterval"
    })
    public static class Pages {

        protected PageIntervalType pageInterval;

        /**
         * Gets the value of the pageInterval property.
         * 
         * @return
         *     possible object is
         *     {@link PageIntervalType }
         *     
         */
        public PageIntervalType getPageInterval() {
            return pageInterval;
        }

        /**
         * Sets the value of the pageInterval property.
         * 
         * @param value
         *     allowed object is
         *     {@link PageIntervalType }
         *     
         */
        public void setPageInterval(PageIntervalType value) {
            this.pageInterval = value;
        }

        public boolean isSetPageInterval() {
            return (this.pageInterval!= null);
        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="x" default="0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="y" default="0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="mm" />
     *       <attribute name="position" type="{http://schema.webpdf.de/1.0/operation}BackgroundPositionModeType" default="center_center" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Position {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;X-axis position of rectangle.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "x")
        protected Float x;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Y-axis position of rectangle.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "y")
        protected Float y;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Unit used to specify the background's X-axis / Y-axis position:&#13;
         *                                     &lt;ul&gt;&lt;li&gt;pt = Points (1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas (12 points)&lt;/li&gt;&lt;li&gt;px = Pixels (1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "metrics")
        protected MetricsType metrics;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Uses one of multiple preset positions in order to position the background on the page.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;custom = Disable the use of a preset position.&lt;/li&gt;&lt;li&gt;top_left = Positions the background in the top left corner.&lt;/li&gt;&lt;li&gt;top_center = Positions the background in the centre on the top margin.&lt;/li&gt;&lt;li&gt;top_right = Positions the background in the top right corner.&lt;/li&gt;&lt;li&gt;center_left = Positions the background at the centre of the page, to the left.&lt;/li&gt;&lt;li&gt;center_center = Positions the background at the centre of the page.&lt;/li&gt;&lt;li&gt;center_right = Positions the background at the centre of the page, to the right.&lt;/li&gt;&lt;li&gt;bottom_left = Positions the background in the bottom left corner.&lt;/li&gt;&lt;li&gt;bottom_center = Positions the background in the centre on the bottom margin.&lt;/li&gt;&lt;li&gt;bottom_right = Positions the background in the bottom right corner.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "position")
        protected BackgroundPositionModeType position;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;X-axis position of rectangle.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getX() {
            if (x == null) {
                return  0.0F;
            } else {
                return x;
            }
        }

        /**
         * Sets the value of the x property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getX()
         */
        public void setX(float value) {
            this.x = value;
        }

        public boolean isSetX() {
            return (this.x!= null);
        }

        public void unsetX() {
            this.x = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Y-axis position of rectangle.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getY() {
            if (y == null) {
                return  0.0F;
            } else {
                return y;
            }
        }

        /**
         * Sets the value of the y property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getY()
         */
        public void setY(float value) {
            this.y = value;
        }

        public boolean isSetY() {
            return (this.y!= null);
        }

        public void unsetY() {
            this.y = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Unit used to specify the background's X-axis / Y-axis position:&#13;
         *                                     &lt;ul&gt;&lt;li&gt;pt = Points (1/72 inch)&lt;/li&gt;&lt;li&gt;pc = Picas (12 points)&lt;/li&gt;&lt;li&gt;px = Pixels (1/96 inch)&lt;/li&gt;&lt;li&gt;mm = Millimeters&lt;/li&gt;&lt;li&gt;in = Inches&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link MetricsType }
         *     
         */
        public MetricsType getMetrics() {
            if (metrics == null) {
                return MetricsType.MM;
            } else {
                return metrics;
            }
        }

        /**
         * Sets the value of the metrics property.
         * 
         * @param value
         *     allowed object is
         *     {@link MetricsType }
         *     
         * @see #getMetrics()
         */
        public void setMetrics(MetricsType value) {
            this.metrics = value;
        }

        public boolean isSetMetrics() {
            return (this.metrics!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Uses one of multiple preset positions in order to position the background on the page.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;custom = Disable the use of a preset position.&lt;/li&gt;&lt;li&gt;top_left = Positions the background in the top left corner.&lt;/li&gt;&lt;li&gt;top_center = Positions the background in the centre on the top margin.&lt;/li&gt;&lt;li&gt;top_right = Positions the background in the top right corner.&lt;/li&gt;&lt;li&gt;center_left = Positions the background at the centre of the page, to the left.&lt;/li&gt;&lt;li&gt;center_center = Positions the background at the centre of the page.&lt;/li&gt;&lt;li&gt;center_right = Positions the background at the centre of the page, to the right.&lt;/li&gt;&lt;li&gt;bottom_left = Positions the background in the bottom left corner.&lt;/li&gt;&lt;li&gt;bottom_center = Positions the background in the centre on the bottom margin.&lt;/li&gt;&lt;li&gt;bottom_right = Positions the background in the bottom right corner.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link BackgroundPositionModeType }
         *     
         */
        public BackgroundPositionModeType getPosition() {
            if (position == null) {
                return BackgroundPositionModeType.CENTER_CENTER;
            } else {
                return position;
            }
        }

        /**
         * Sets the value of the position property.
         * 
         * @param value
         *     allowed object is
         *     {@link BackgroundPositionModeType }
         *     
         * @see #getPosition()
         */
        public void setPosition(BackgroundPositionModeType value) {
            this.position = value;
        }

        public boolean isSetPosition() {
            return (this.position!= null);
        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="onPrint" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *       <attribute name="onScreen" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Visibility {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the background will be printed when the document is printed.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "onPrint")
        protected Boolean onPrint;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the background will be shown when the document is displayed.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "onScreen")
        protected Boolean onScreen;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the background will be printed when the document is printed.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isOnPrint() {
            if (onPrint == null) {
                return true;
            } else {
                return onPrint;
            }
        }

        /**
         * Sets the value of the onPrint property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isOnPrint()
         */
        public void setOnPrint(boolean value) {
            this.onPrint = value;
        }

        public boolean isSetOnPrint() {
            return (this.onPrint!= null);
        }

        public void unsetOnPrint() {
            this.onPrint = null;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p356330_="https://jakarta.ee/xml/ns/jaxb" xmlns:p467749_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p726494_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the background will be shown when the document is displayed.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isOnScreen() {
            if (onScreen == null) {
                return true;
            } else {
                return onScreen;
            }
        }

        /**
         * Sets the value of the onScreen property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isOnScreen()
         */
        public void setOnScreen(boolean value) {
            this.onScreen = value;
        }

        public boolean isSetOnScreen() {
            return (this.onScreen!= null);
        }

        public void unsetOnScreen() {
            this.onScreen = null;
        }

    }

}
