
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p122528_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p474718_="https://jakarta.ee/xml/ns/jaxb" xmlns:p929760_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A aztec barcode.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for AztecBarcodeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="AztecBarcodeType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseBarcodeType">
 *       <attribute name="errorCorrection" default="7">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="layers" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="-4"/>
 *             <maxInclusive value="32"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AztecBarcodeType")
public class AztecBarcodeType
    extends BaseBarcodeType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p122528_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p474718_="https://jakarta.ee/xml/ns/jaxb" xmlns:p929760_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to adjust the error correction level for generated Aztec Codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A percentage value of one to one hundred can be entered.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "errorCorrection")
    protected Integer errorCorrection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p122528_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p474718_="https://jakarta.ee/xml/ns/jaxb" xmlns:p929760_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the number of layers that the generated Aztec Code should use. The higher the number, the larger the resulting barcode and its capacity.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;"-4" to "-1" = Compact Aztec Code with a minimum capacity of 13 digits or 12 letters and an area of 15 x 15 pixels.&lt;/li&gt;&lt;li&gt;"0" = Standard Aztec Code that will be optimized in order to use the smallest possible of layers for the value that is being encoded.&lt;/li&gt;&lt;li&gt;"1" to "32" = Standard Aztec Code with a maximum capacity of 3832 digits or 3067 letters and an area of 151 x 151 pixels.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "layers")
    protected Integer layers;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p122528_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p474718_="https://jakarta.ee/xml/ns/jaxb" xmlns:p929760_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to adjust the error correction level for generated Aztec Codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A percentage value of one to one hundred can be entered.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getErrorCorrection() {
        if (errorCorrection == null) {
            return  7;
        } else {
            return errorCorrection;
        }
    }

    /**
     * Sets the value of the errorCorrection property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getErrorCorrection()
     */
    public void setErrorCorrection(int value) {
        this.errorCorrection = value;
    }

    public boolean isSetErrorCorrection() {
        return (this.errorCorrection!= null);
    }

    public void unsetErrorCorrection() {
        this.errorCorrection = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p122528_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p474718_="https://jakarta.ee/xml/ns/jaxb" xmlns:p929760_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the number of layers that the generated Aztec Code should use. The higher the number, the larger the resulting barcode and its capacity.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;"-4" to "-1" = Compact Aztec Code with a minimum capacity of 13 digits or 12 letters and an area of 15 x 15 pixels.&lt;/li&gt;&lt;li&gt;"0" = Standard Aztec Code that will be optimized in order to use the smallest possible of layers for the value that is being encoded.&lt;/li&gt;&lt;li&gt;"1" to "32" = Standard Aztec Code with a maximum capacity of 3832 digits or 3067 letters and an area of 151 x 151 pixels.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getLayers() {
        if (layers == null) {
            return  0;
        } else {
            return layers;
        }
    }

    /**
     * Sets the value of the layers property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getLayers()
     */
    public void setLayers(int value) {
        this.layers = value;
    }

    public boolean isSetLayers() {
        return (this.layers!= null);
    }

    public void unsetLayers() {
        this.layers = null;
    }

}
