
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the manner in which attachments are to be processed in e-mails.&#13;
 *                     &lt;ul&gt;&lt;li&gt;embed = Embed in original format&lt;/li&gt;&lt;li&gt;remove = Remove attachments&lt;/li&gt;&lt;li&gt;convert = Converts the attachments to PDF format and embeds them as an attachment&lt;/li&gt;&lt;li&gt;convertMerge = Converts the attachments to PDF format and appends them as additional page(s) at the end&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p532746_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p882137_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     If conversion to PDF format is not possible when using "convert" or "convertMerge", the attachment will be embedded in its original format.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for AttachmentModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="AttachmentModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="embed"/>
 *     <enumeration value="remove"/>
 *     <enumeration value="convert"/>
 *     <enumeration value="convertMerge"/>
 *     <enumeration value="convertEmbed"/>
 *     <enumeration value="convertMergeEmbed"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AttachmentModeType")
@XmlEnum
public enum AttachmentModeType {

    @XmlEnumValue("embed")
    EMBED("embed"),
    @XmlEnumValue("remove")
    REMOVE("remove"),
    @XmlEnumValue("convert")
    CONVERT("convert"),
    @XmlEnumValue("convertMerge")
    CONVERT_MERGE("convertMerge"),
    @XmlEnumValue("convertEmbed")
    CONVERT_EMBED("convertEmbed"),
    @XmlEnumValue("convertMergeEmbed")
    CONVERT_MERGE_EMBED("convertMergeEmbed");
    private final String value;

    AttachmentModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static AttachmentModeType fromValue(String v) {
        for (AttachmentModeType c: AttachmentModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
