/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The setTransition action shows the changes that result from the actions with the use of the defined transition animation.
 */
@Schema(description = "The setTransition action shows the changes that result from the actions with the use of the defined transition animation.")
@JsonPropertyOrder({
  OperationTransitionActionSetTransition.JSON_PROPERTY_DIRECTION,
  OperationTransitionActionSetTransition.JSON_PROPERTY_DURATION,
  OperationTransitionActionSetTransition.JSON_PROPERTY_EFFECT_DIMENSION_HORIZONTAL,
  OperationTransitionActionSetTransition.JSON_PROPERTY_FLY_AREA_OPAQUE,
  OperationTransitionActionSetTransition.JSON_PROPERTY_FLY_SCALE,
  OperationTransitionActionSetTransition.JSON_PROPERTY_MOTION_INWARD,
  OperationTransitionActionSetTransition.JSON_PROPERTY_SCALING,
  OperationTransitionActionSetTransition.JSON_PROPERTY_STYLE
})
@JsonTypeName("Operation_TransitionAction_setTransition")

public class OperationTransitionActionSetTransition {
  /**
   * The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight &#x3D; From left to right *   bottomToTop &#x3D; From bottom to top *   rightToLeft &#x3D; From right to left *   topToBottom &#x3D; From top to bottom *   topLeftToBottomRight &#x3D; From top left to bottom right *   none &#x3D; Use the default value for the animation
   */
  public enum DirectionEnum {
    LEFT_TO_RIGHT(String.valueOf("leftToRight")),
    
    BOTTOM_TO_TOP(String.valueOf("bottomToTop")),
    
    RIGHT_TO_LEFT(String.valueOf("rightToLeft")),
    
    TOP_TO_BOTTOM(String.valueOf("topToBottom")),
    
    TOP_LEFT_TO_BOTTOM_RIGHT(String.valueOf("topLeftToBottomRight")),
    
    NONE(String.valueOf("none"));

    private String value;

    DirectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DirectionEnum fromValue(String value) {
      for (DirectionEnum b : DirectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DIRECTION = "direction";
  private DirectionEnum direction = DirectionEnum.LEFT_TO_RIGHT;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private Float duration = 1f;

  public static final String JSON_PROPERTY_EFFECT_DIMENSION_HORIZONTAL = "effectDimensionHorizontal";
  private Boolean effectDimensionHorizontal = true;

  public static final String JSON_PROPERTY_FLY_AREA_OPAQUE = "flyAreaOpaque";
  private Boolean flyAreaOpaque = false;

  public static final String JSON_PROPERTY_FLY_SCALE = "flyScale";
  private Integer flyScale = 100;

  public static final String JSON_PROPERTY_MOTION_INWARD = "motionInward";
  private Boolean motionInward = true;

  public static final String JSON_PROPERTY_SCALING = "scaling";
  private Integer scaling = 100;

  /**
   * The style of transition animation.  *   blinds &#x3D; Crossfades *   box &#x3D; Crossfades in a rectangular pattern *   cover &#x3D; Covers *   dissolve &#x3D; Dissolves *   fade &#x3D; Fades *   fly &#x3D; Page flies in *   glitter &#x3D; Page dissolves and is replaced *   push &#x3D; Page is pushed out *   split &#x3D; Splits page *   uncover &#x3D; Uncovers page *   wipe &#x3D; Wipes page *   none &#x3D; No special effect
   */
  public enum StyleEnum {
    BLINDS(String.valueOf("blinds")),
    
    BOX(String.valueOf("box")),
    
    COVER(String.valueOf("cover")),
    
    DISSOLVE(String.valueOf("dissolve")),
    
    FADE(String.valueOf("fade")),
    
    FLY(String.valueOf("fly")),
    
    GLITTER(String.valueOf("glitter")),
    
    PUSH(String.valueOf("push")),
    
    SPLIT(String.valueOf("split")),
    
    UNCOVER(String.valueOf("uncover")),
    
    WIPE(String.valueOf("wipe")),
    
    NONE(String.valueOf("none"));

    private String value;

    StyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StyleEnum fromValue(String value) {
      for (StyleEnum b : StyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STYLE = "style";
  private StyleEnum style = StyleEnum.NONE;

  public OperationTransitionActionSetTransition() {
  }

  public OperationTransitionActionSetTransition direction(DirectionEnum direction) {
    
    this.direction = direction;
    return this;
  }

  /**
   * The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight &#x3D; From left to right *   bottomToTop &#x3D; From bottom to top *   rightToLeft &#x3D; From right to left *   topToBottom &#x3D; From top to bottom *   topLeftToBottomRight &#x3D; From top left to bottom right *   none &#x3D; Use the default value for the animation
   * @return direction
   **/
  @Nullable
  @Schema(name = "The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight = From left to right *   bottomToTop = From bottom to top *   rightToLeft = From right to left *   topToBottom = From top to bottom *   topLeftToBottomRight = From top left to bottom right *   none = Use the default value for the animation")
  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DirectionEnum getDirection() {
    return direction;
  }


  @JsonProperty(JSON_PROPERTY_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDirection(DirectionEnum direction) {
    this.direction = direction;
  }


  public OperationTransitionActionSetTransition duration(Float duration) {
    
    this.duration = duration;
    return this;
  }

  /**
   * The page transition animation&#39;s duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommended.
   * minimum: 0
   * @return duration
   **/
  @Nullable
  @Schema(name = "The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommended.")
  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuration(Float duration) {
    this.duration = duration;
  }


  public OperationTransitionActionSetTransition effectDimensionHorizontal(Boolean effectDimensionHorizontal) {
    
    this.effectDimensionHorizontal = effectDimensionHorizontal;
    return this;
  }

  /**
   * Option for the split and blinds animation styles - used to define the axis along which the effect should happen. true corresponds to the horizontal axis; false to the vertical one.
   * @return effectDimensionHorizontal
   **/
  @Nullable
  @Schema(name = "Option for the split and blinds animation styles - used to define the axis along which the effect should happen. true corresponds to the horizontal axis; false to the vertical one.")
  @JsonProperty(JSON_PROPERTY_EFFECT_DIMENSION_HORIZONTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEffectDimensionHorizontal() {
    return effectDimensionHorizontal;
  }


  @JsonProperty(JSON_PROPERTY_EFFECT_DIMENSION_HORIZONTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEffectDimensionHorizontal(Boolean effectDimensionHorizontal) {
    this.effectDimensionHorizontal = effectDimensionHorizontal;
  }


  public OperationTransitionActionSetTransition flyAreaOpaque(Boolean flyAreaOpaque) {
    
    this.flyAreaOpaque = flyAreaOpaque;
    return this;
  }

  /**
   * Option for the \&quot;fly\&quot; animation style - used to define whether the page background for the page that flies in should be transparent initially.
   * @return flyAreaOpaque
   **/
  @Nullable
  @Schema(name = "Option for the \"fly\" animation style - used to define whether the page background for the page that flies in should be transparent initially.")
  @JsonProperty(JSON_PROPERTY_FLY_AREA_OPAQUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFlyAreaOpaque() {
    return flyAreaOpaque;
  }


  @JsonProperty(JSON_PROPERTY_FLY_AREA_OPAQUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlyAreaOpaque(Boolean flyAreaOpaque) {
    this.flyAreaOpaque = flyAreaOpaque;
  }


  public OperationTransitionActionSetTransition flyScale(Integer flyScale) {
    
    this.flyScale = flyScale;
    return this;
  }

  /**
   * Option for the \&quot;fly\&quot; animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed (defined as a percentage).
   * minimum: 0
   * maximum: 6400
   * @return flyScale
   **/
  @Nullable
  @Schema(name = "Option for the \"fly\" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed (defined as a percentage).")
  @JsonProperty(JSON_PROPERTY_FLY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFlyScale() {
    return flyScale;
  }


  @JsonProperty(JSON_PROPERTY_FLY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlyScale(Integer flyScale) {
    this.flyScale = flyScale;
  }


  public OperationTransitionActionSetTransition motionInward(Boolean motionInward) {
    
    this.motionInward = motionInward;
    return this;
  }

  /**
   * Option for the split, box, and fly animation styles - defines whether the animation direction will be from the edges of the page towards the centre (true) or from the centre towards the edges (false).
   * @return motionInward
   **/
  @Nullable
  @Schema(name = "Option for the split, box, and fly animation styles - defines whether the animation direction will be from the edges of the page towards the centre (true) or from the centre towards the edges (false).")
  @JsonProperty(JSON_PROPERTY_MOTION_INWARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMotionInward() {
    return motionInward;
  }


  @JsonProperty(JSON_PROPERTY_MOTION_INWARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMotionInward(Boolean motionInward) {
    this.motionInward = motionInward;
  }


  public OperationTransitionActionSetTransition scaling(Integer scaling) {
    
    this.scaling = scaling;
    return this;
  }

  /**
   * Used to set the value for zooming (as a percentage).
   * minimum: 0
   * @return scaling
   **/
  @Nullable
  @Schema(name = "Used to set the value for zooming (as a percentage).")
  @JsonProperty(JSON_PROPERTY_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getScaling() {
    return scaling;
  }


  @JsonProperty(JSON_PROPERTY_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScaling(Integer scaling) {
    this.scaling = scaling;
  }


  public OperationTransitionActionSetTransition style(StyleEnum style) {
    
    this.style = style;
    return this;
  }

  /**
   * The style of transition animation.  *   blinds &#x3D; Crossfades *   box &#x3D; Crossfades in a rectangular pattern *   cover &#x3D; Covers *   dissolve &#x3D; Dissolves *   fade &#x3D; Fades *   fly &#x3D; Page flies in *   glitter &#x3D; Page dissolves and is replaced *   push &#x3D; Page is pushed out *   split &#x3D; Splits page *   uncover &#x3D; Uncovers page *   wipe &#x3D; Wipes page *   none &#x3D; No special effect
   * @return style
   **/
  @Nullable
  @Schema(name = "The style of transition animation.  *   blinds = Crossfades *   box = Crossfades in a rectangular pattern *   cover = Covers *   dissolve = Dissolves *   fade = Fades *   fly = Page flies in *   glitter = Page dissolves and is replaced *   push = Page is pushed out *   split = Splits page *   uncover = Uncovers page *   wipe = Wipes page *   none = No special effect")
  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StyleEnum getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(StyleEnum style) {
    this.style = style;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationTransitionActionSetTransition operationTransitionActionSetTransition = (OperationTransitionActionSetTransition) o;
    return Objects.equals(this.direction, operationTransitionActionSetTransition.direction) &&
        Objects.equals(this.duration, operationTransitionActionSetTransition.duration) &&
        Objects.equals(this.effectDimensionHorizontal, operationTransitionActionSetTransition.effectDimensionHorizontal) &&
        Objects.equals(this.flyAreaOpaque, operationTransitionActionSetTransition.flyAreaOpaque) &&
        Objects.equals(this.flyScale, operationTransitionActionSetTransition.flyScale) &&
        Objects.equals(this.motionInward, operationTransitionActionSetTransition.motionInward) &&
        Objects.equals(this.scaling, operationTransitionActionSetTransition.scaling) &&
        Objects.equals(this.style, operationTransitionActionSetTransition.style);
  }

  @Override
  public int hashCode() {
    return Objects.hash(direction, duration, effectDimensionHorizontal, flyAreaOpaque, flyScale, motionInward, scaling, style);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationTransitionActionSetTransition {\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    effectDimensionHorizontal: ").append(toIndentedString(effectDimensionHorizontal)).append("\n");
    sb.append("    flyAreaOpaque: ").append(toIndentedString(flyAreaOpaque)).append("\n");
    sb.append("    flyScale: ").append(toIndentedString(flyScale)).append("\n");
    sb.append("    motionInward: ").append(toIndentedString(motionInward)).append("\n");
    sb.append("    scaling: ").append(toIndentedString(scaling)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
