/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The extraction operation element can be used to extract various contents.  **Tip:** The format of the document generated with the \&quot;extraction\&quot; operation is described by the [\&quot;text.xsd\&quot;](http://schema.webpdf.de/1.0/extraction/text.xsd) schema for &#x60;&lt;text&gt;&#x60;, &#x60;&lt;links&gt;&#x60;, &#x60;&lt;words&gt;&#x60;, and &#x60;&lt;paragraphs&gt;&#x60; and by the [info.xsd](http://schema.webpdf.de/1.0/extraction/info.xsd) schema for &#x60;&lt;info&gt;&#x60;.
 */
@Schema(description = "The extraction operation element can be used to extract various contents.  **Tip:** The format of the document generated with the \"extraction\" operation is described by the [\"text.xsd\"](http://schema.webpdf.de/1.0/extraction/text.xsd) schema for `<text>`, `<links>`, `<words>`, and `<paragraphs>` and by the [info.xsd](http://schema.webpdf.de/1.0/extraction/info.xsd) schema for `<info>`.")
@JsonPropertyOrder({
  OperationToolboxExtractionExtraction.JSON_PROPERTY_IMAGES,
  OperationToolboxExtractionExtraction.JSON_PROPERTY_INFO,
  OperationToolboxExtractionExtraction.JSON_PROPERTY_LINKS,
  OperationToolboxExtractionExtraction.JSON_PROPERTY_PARAGRAPHS,
  OperationToolboxExtractionExtraction.JSON_PROPERTY_TEXT,
  OperationToolboxExtractionExtraction.JSON_PROPERTY_WORDS
})
@JsonTypeName("Operation_ToolboxExtraction_extraction")

public class OperationToolboxExtractionExtraction {
  public static final String JSON_PROPERTY_IMAGES = "images";
  private OperationExtractionImages images;

  public static final String JSON_PROPERTY_INFO = "info";
  private OperationExtractionInfo info;

  public static final String JSON_PROPERTY_LINKS = "links";
  private OperationExtractionLinks links;

  public static final String JSON_PROPERTY_PARAGRAPHS = "paragraphs";
  private OperationExtractionParagraphs paragraphs;

  public static final String JSON_PROPERTY_TEXT = "text";
  private OperationExtractionText text;

  public static final String JSON_PROPERTY_WORDS = "words";
  private OperationExtractionWords words;

  public OperationToolboxExtractionExtraction() {
  }

  public OperationToolboxExtractionExtraction images(OperationExtractionImages images) {
    
    this.images = images;
    return this;
  }

  /**
   * Get images
   * @return images
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationExtractionImages getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(OperationExtractionImages images) {
    this.images = images;
  }


  public OperationToolboxExtractionExtraction info(OperationExtractionInfo info) {
    
    this.info = info;
    return this;
  }

  /**
   * Get info
   * @return info
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationExtractionInfo getInfo() {
    return info;
  }


  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfo(OperationExtractionInfo info) {
    this.info = info;
  }


  public OperationToolboxExtractionExtraction links(OperationExtractionLinks links) {
    
    this.links = links;
    return this;
  }

  /**
   * Get links
   * @return links
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationExtractionLinks getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(OperationExtractionLinks links) {
    this.links = links;
  }


  public OperationToolboxExtractionExtraction paragraphs(OperationExtractionParagraphs paragraphs) {
    
    this.paragraphs = paragraphs;
    return this;
  }

  /**
   * Get paragraphs
   * @return paragraphs
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PARAGRAPHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationExtractionParagraphs getParagraphs() {
    return paragraphs;
  }


  @JsonProperty(JSON_PROPERTY_PARAGRAPHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParagraphs(OperationExtractionParagraphs paragraphs) {
    this.paragraphs = paragraphs;
  }


  public OperationToolboxExtractionExtraction text(OperationExtractionText text) {
    
    this.text = text;
    return this;
  }

  /**
   * Get text
   * @return text
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationExtractionText getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(OperationExtractionText text) {
    this.text = text;
  }


  public OperationToolboxExtractionExtraction words(OperationExtractionWords words) {
    
    this.words = words;
    return this;
  }

  /**
   * Get words
   * @return words
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_WORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationExtractionWords getWords() {
    return words;
  }


  @JsonProperty(JSON_PROPERTY_WORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWords(OperationExtractionWords words) {
    this.words = words;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxExtractionExtraction operationToolboxExtractionExtraction = (OperationToolboxExtractionExtraction) o;
    return Objects.equals(this.images, operationToolboxExtractionExtraction.images) &&
        Objects.equals(this.info, operationToolboxExtractionExtraction.info) &&
        Objects.equals(this.links, operationToolboxExtractionExtraction.links) &&
        Objects.equals(this.paragraphs, operationToolboxExtractionExtraction.paragraphs) &&
        Objects.equals(this.text, operationToolboxExtractionExtraction.text) &&
        Objects.equals(this.words, operationToolboxExtractionExtraction.words);
  }

  @Override
  public int hashCode() {
    return Objects.hash(images, info, links, paragraphs, text, words);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxExtractionExtraction {\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    info: ").append(toIndentedString(info)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    paragraphs: ").append(toIndentedString(paragraphs)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    words: ").append(toIndentedString(words)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
