/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Allows editing the content and properties of a textual reply to another annotation.
 */
@Schema(description = "Allows editing the content and properties of a textual reply to another annotation.")
@JsonPropertyOrder({
  OperationReplyToAnnotationEdit.JSON_PROPERTY_COMMENT,
  OperationReplyToAnnotationEdit.JSON_PROPERTY_CREATOR,
  OperationReplyToAnnotationEdit.JSON_PROPERTY_NAME,
  OperationReplyToAnnotationEdit.JSON_PROPERTY_OBJECT_KEY,
  OperationReplyToAnnotationEdit.JSON_PROPERTY_PAGE,
  OperationReplyToAnnotationEdit.JSON_PROPERTY_SUBJECT
})
@JsonTypeName("Operation_ReplyToAnnotationEdit")

public class OperationReplyToAnnotationEdit {
  public static final String JSON_PROPERTY_COMMENT = "comment";
  private String comment = "";

  public static final String JSON_PROPERTY_CREATOR = "creator";
  private String creator = "";

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private OperationObjectKeyReplyToAnnotationEdit objectKey;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 1;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject = "";

  public OperationReplyToAnnotationEdit() {
  }

  public OperationReplyToAnnotationEdit comment(String comment) {
    
    this.comment = comment;
    return this;
  }

  /**
   * This value is used to set the textual comment/reply to display.
   * @return comment
   **/
  @Nullable
  @Schema(name = "This value is used to set the textual comment/reply to display.")
  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getComment() {
    return comment;
  }


  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComment(String comment) {
    this.comment = comment;
  }


  public OperationReplyToAnnotationEdit creator(String creator) {
    
    this.creator = creator;
    return this;
  }

  /**
   * Used to specify the author of the annotation.
   * @return creator
   **/
  @Nullable
  @Schema(name = "Used to specify the author of the annotation.")
  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreator() {
    return creator;
  }


  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreator(String creator) {
    this.creator = creator;
  }


  public OperationReplyToAnnotationEdit name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Used to specify the name of the annotation.
   * @return name
   **/
  @Nullable
  @Schema(name = "Used to specify the name of the annotation.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public OperationReplyToAnnotationEdit objectKey(OperationObjectKeyReplyToAnnotationEdit objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * Get objectKey
   * @return objectKey
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OperationObjectKeyReplyToAnnotationEdit getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setObjectKey(OperationObjectKeyReplyToAnnotationEdit objectKey) {
    this.objectKey = objectKey;
  }


  public OperationReplyToAnnotationEdit page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * Selects the page by page number, that shall contain the \&quot;reply to\&quot; annotation.
   * minimum: 1
   * @return page
   **/
  @Nullable
  @Schema(name = "Selects the page by page number, that shall contain the \"reply to\" annotation.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public OperationReplyToAnnotationEdit subject(String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Used to specify the subject of the annotation.
   * @return subject
   **/
  @Nullable
  @Schema(name = "Used to specify the subject of the annotation.")
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationReplyToAnnotationEdit operationReplyToAnnotationEdit = (OperationReplyToAnnotationEdit) o;
    return Objects.equals(this.comment, operationReplyToAnnotationEdit.comment) &&
        Objects.equals(this.creator, operationReplyToAnnotationEdit.creator) &&
        Objects.equals(this.name, operationReplyToAnnotationEdit.name) &&
        Objects.equals(this.objectKey, operationReplyToAnnotationEdit.objectKey) &&
        Objects.equals(this.page, operationReplyToAnnotationEdit.page) &&
        Objects.equals(this.subject, operationReplyToAnnotationEdit.subject);
  }

  @Override
  public int hashCode() {
    return Objects.hash(comment, creator, name, objectKey, page, subject);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationReplyToAnnotationEdit {\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
