/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a target JPEG image format.
 */
@Schema(description = "Defines a target JPEG image format.")
@JsonPropertyOrder({
  OperationJpeg.JSON_PROPERTY_DPI,
  OperationJpeg.JSON_PROPERTY_HEIGHT,
  OperationJpeg.JSON_PROPERTY_JPEG_QUALITY,
  OperationJpeg.JSON_PROPERTY_METRICS,
  OperationJpeg.JSON_PROPERTY_SIZE_OPTIMIZATION,
  OperationJpeg.JSON_PROPERTY_WIDTH
})
@JsonTypeName("Operation_Jpeg")

public class OperationJpeg {
  public static final String JSON_PROPERTY_DPI = "dpi";
  private Integer dpi = 72;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height = 0;

  public static final String JSON_PROPERTY_JPEG_QUALITY = "jpegQuality";
  private Integer jpegQuality = 80;

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   */
  public enum MetricsEnum {
    PT(String.valueOf("pt")),
    
    PC(String.valueOf("pc")),
    
    PX(String.valueOf("px")),
    
    MM(String.valueOf("mm")),
    
    IN(String.valueOf("in"));

    private String value;

    MetricsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MetricsEnum fromValue(String value) {
      for (MetricsEnum b : MetricsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_METRICS = "metrics";
  private MetricsEnum metrics = MetricsEnum.MM;

  public static final String JSON_PROPERTY_SIZE_OPTIMIZATION = "sizeOptimization";
  private OperationSizeOptimization sizeOptimization;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width = 0;

  public OperationJpeg() {
  }

  public OperationJpeg dpi(Integer dpi) {
    
    this.dpi = dpi;
    return this;
  }

  /**
   * This parameter is used to define the image&#39;s DPI resolution. The larger the value, the larger the image&#39;s x, y resolution. In addition, the larger the DPI resolution, the larger the size of the image file.
   * minimum: 0
   * maximum: 9600
   * @return dpi
   **/
  @Nullable
  @Schema(name = "This parameter is used to define the image's DPI resolution. The larger the value, the larger the image's x, y resolution. In addition, the larger the DPI resolution, the larger the size of the image file.")
  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDpi() {
    return dpi;
  }


  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDpi(Integer dpi) {
    this.dpi = dpi;
  }


  public OperationJpeg height(Integer height) {
    
    this.height = height;
    return this;
  }

  /**
   * Used to limit the maximum height of the exported image. 0 &#x3D; No restriction
   * minimum: 0
   * @return height
   **/
  @Nullable
  @Schema(name = "Used to limit the maximum height of the exported image. 0 = No restriction")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  public OperationJpeg jpegQuality(Integer jpegQuality) {
    
    this.jpegQuality = jpegQuality;
    return this;
  }

  /**
   * When exporting to \&quot;jpg\&quot; format, this parameter can be used to define the image&#39;s quality as a percentage. The value must fall between 0 and 100. The larger the value, the better the quality and the lower the compression level.
   * minimum: 0
   * maximum: 100
   * @return jpegQuality
   **/
  @Nullable
  @Schema(name = "When exporting to \"jpg\" format, this parameter can be used to define the image's quality as a percentage. The value must fall between 0 and 100. The larger the value, the better the quality and the lower the compression level.")
  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getJpegQuality() {
    return jpegQuality;
  }


  @JsonProperty(JSON_PROPERTY_JPEG_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJpegQuality(Integer jpegQuality) {
    this.jpegQuality = jpegQuality;
  }


  public OperationJpeg metrics(MetricsEnum metrics) {
    
    this.metrics = metrics;
    return this;
  }

  /**
   * Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt &#x3D; Points(1/72 inch) *   pc &#x3D; Picas(12 points) *   px &#x3D; Pixels(1/96 inch) *   mm &#x3D; Millimeters *   in &#x3D; Inches
   * @return metrics
   **/
  @Nullable
  @Schema(name = "Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetricsEnum getMetrics() {
    return metrics;
  }


  @JsonProperty(JSON_PROPERTY_METRICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetrics(MetricsEnum metrics) {
    this.metrics = metrics;
  }


  public OperationJpeg sizeOptimization(OperationSizeOptimization sizeOptimization) {
    
    this.sizeOptimization = sizeOptimization;
    return this;
  }

  /**
   * Get sizeOptimization
   * @return sizeOptimization
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SIZE_OPTIMIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSizeOptimization getSizeOptimization() {
    return sizeOptimization;
  }


  @JsonProperty(JSON_PROPERTY_SIZE_OPTIMIZATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSizeOptimization(OperationSizeOptimization sizeOptimization) {
    this.sizeOptimization = sizeOptimization;
  }


  public OperationJpeg width(Integer width) {
    
    this.width = width;
    return this;
  }

  /**
   * Used to limit the maximum width of the exported image. 0 &#x3D; No restriction
   * minimum: 0
   * @return width
   **/
  @Nullable
  @Schema(name = "Used to limit the maximum width of the exported image. 0 = No restriction")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationJpeg operationJpeg = (OperationJpeg) o;
    return Objects.equals(this.dpi, operationJpeg.dpi) &&
        Objects.equals(this.height, operationJpeg.height) &&
        Objects.equals(this.jpegQuality, operationJpeg.jpegQuality) &&
        Objects.equals(this.metrics, operationJpeg.metrics) &&
        Objects.equals(this.sizeOptimization, operationJpeg.sizeOptimization) &&
        Objects.equals(this.width, operationJpeg.width);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dpi, height, jpegQuality, metrics, sizeOptimization, width);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationJpeg {\n");
    sb.append("    dpi: ").append(toIndentedString(dpi)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    jpegQuality: ").append(toIndentedString(jpegQuality)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    sizeOptimization: ").append(toIndentedString(sizeOptimization)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
