/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Extract the PDF document&#39;s image contents  Generates a ZIP file that is returned as a result when the web service is called. This file will contain all the images contained at the page level in a freely selectable page range.  **Important:** The images mode can only be used to extract raster graphics (bitmap images). The extraction vector graphics, as well as the rendering of vector graphics based on vectorial drawing paths, is not supported.  **Important:** Due to licensing reasons, the images mode currently only supports the extraction of basic JPEG2000 images that conform to the part-1 core coding system definition in ISO/IEC 15444-1.  **Important:** It cannot be guaranteed that an image will be exported in its original source format, as the image may have already been converted when embedded in the PDF (this depends on whether the source format was supported by the PDF standard and on the application that was used to embed the image).
 */
@Schema(description = "Extract the PDF document's image contents  Generates a ZIP file that is returned as a result when the web service is called. This file will contain all the images contained at the page level in a freely selectable page range.  **Important:** The images mode can only be used to extract raster graphics (bitmap images). The extraction vector graphics, as well as the rendering of vector graphics based on vectorial drawing paths, is not supported.  **Important:** Due to licensing reasons, the images mode currently only supports the extraction of basic JPEG2000 images that conform to the part-1 core coding system definition in ISO/IEC 15444-1.  **Important:** It cannot be guaranteed that an image will be exported in its original source format, as the image may have already been converted when embedded in the PDF (this depends on whether the source format was supported by the PDF standard and on the application that was used to embed the image).")
@JsonPropertyOrder({
  OperationExtractionImages.JSON_PROPERTY_FALLBACK_FORMAT,
  OperationExtractionImages.JSON_PROPERTY_FILE_FORMAT,
  OperationExtractionImages.JSON_PROPERTY_FILE_NAME_TEMPLATE,
  OperationExtractionImages.JSON_PROPERTY_FOLDER_NAME_TEMPLATE,
  OperationExtractionImages.JSON_PROPERTY_PAGES
})
@JsonTypeName("Operation_ExtractionImages")

public class OperationExtractionImages {
  /**
   * Used to specify the format that should be used as the fallback format if extracting an image would result in a format that is not supported.  *   png &#x3D; PNG file *   jpeg &#x3D; JPEG file
   */
  public enum FallbackFormatEnum {
    PNG(String.valueOf("png")),
    
    JPEG(String.valueOf("jpeg"));

    private String value;

    FallbackFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FallbackFormatEnum fromValue(String value) {
      for (FallbackFormatEnum b : FallbackFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FALLBACK_FORMAT = "fallbackFormat";
  private FallbackFormatEnum fallbackFormat = FallbackFormatEnum.PNG;

  /**
   * Used to define the output format for the PDF document text contents being extracted.  *   text &#x3D; Text document *   xml &#x3D; XML document *   json &#x3D; JSON data structure
   */
  public enum FileFormatEnum {
    TEXT(String.valueOf("text")),
    
    XML(String.valueOf("xml")),
    
    JSON(String.valueOf("json")),
    
    ZIP(String.valueOf("zip"));

    private String value;

    FileFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FileFormatEnum fromValue(String value) {
      for (FileFormatEnum b : FileFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FILE_FORMAT = "fileFormat";
  private FileFormatEnum fileFormat = FileFormatEnum.ZIP;

  public static final String JSON_PROPERTY_FILE_NAME_TEMPLATE = "fileNameTemplate";
  private String fileNameTemplate = "file[%d]";

  public static final String JSON_PROPERTY_FOLDER_NAME_TEMPLATE = "folderNameTemplate";
  private String folderNameTemplate = "page[%d]";

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  public OperationExtractionImages() {
  }

  public OperationExtractionImages fallbackFormat(FallbackFormatEnum fallbackFormat) {
    
    this.fallbackFormat = fallbackFormat;
    return this;
  }

  /**
   * Used to specify the format that should be used as the fallback format if extracting an image would result in a format that is not supported.  *   png &#x3D; PNG file *   jpeg &#x3D; JPEG file
   * @return fallbackFormat
   **/
  @Nullable
  @Schema(name = "Used to specify the format that should be used as the fallback format if extracting an image would result in a format that is not supported.  *   png = PNG file *   jpeg = JPEG file")
  @JsonProperty(JSON_PROPERTY_FALLBACK_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FallbackFormatEnum getFallbackFormat() {
    return fallbackFormat;
  }


  @JsonProperty(JSON_PROPERTY_FALLBACK_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFallbackFormat(FallbackFormatEnum fallbackFormat) {
    this.fallbackFormat = fallbackFormat;
  }


  public OperationExtractionImages fileFormat(FileFormatEnum fileFormat) {
    
    this.fileFormat = fileFormat;
    return this;
  }

  /**
   * Used to define the output format for the PDF document text contents being extracted.  *   text &#x3D; Text document *   xml &#x3D; XML document *   json &#x3D; JSON data structure
   * @return fileFormat
   **/
  @Nullable
  @Schema(name = "Used to define the output format for the PDF document text contents being extracted.  *   text = Text document *   xml = XML document *   json = JSON data structure")
  @JsonProperty(JSON_PROPERTY_FILE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FileFormatEnum getFileFormat() {
    return fileFormat;
  }


  @JsonProperty(JSON_PROPERTY_FILE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileFormat(FileFormatEnum fileFormat) {
    this.fileFormat = fileFormat;
  }


  public OperationExtractionImages fileNameTemplate(String fileNameTemplate) {
    
    this.fileNameTemplate = fileNameTemplate;
    return this;
  }

  /**
   * Used to set the template for the image files in the returned ZIP file. \&quot;file\\[%d\\]\&quot;, for example, would result in a \&quot;file\\[1\\].png\&quot; entry for a PNG image.
   * @return fileNameTemplate
   **/
  @Nullable
  @Schema(name = "Used to set the template for the image files in the returned ZIP file. \"file\\[%d\\]\", for example, would result in a \"file\\[1\\].png\" entry for a PNG image.")
  @JsonProperty(JSON_PROPERTY_FILE_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileNameTemplate() {
    return fileNameTemplate;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileNameTemplate(String fileNameTemplate) {
    this.fileNameTemplate = fileNameTemplate;
  }


  public OperationExtractionImages folderNameTemplate(String folderNameTemplate) {
    
    this.folderNameTemplate = folderNameTemplate;
    return this;
  }

  /**
   * Used to set the template for the page folders in the returned ZIP file. \&quot;page\\[%d\\]\&quot;, for example, would result in a folder called \&quot;page\\[1\\]\&quot; for page 1, etc.
   * @return folderNameTemplate
   **/
  @Nullable
  @Schema(name = "Used to set the template for the page folders in the returned ZIP file. \"page\\[%d\\]\", for example, would result in a folder called \"page\\[1\\]\" for page 1, etc.")
  @JsonProperty(JSON_PROPERTY_FOLDER_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFolderNameTemplate() {
    return folderNameTemplate;
  }


  @JsonProperty(JSON_PROPERTY_FOLDER_NAME_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFolderNameTemplate(String folderNameTemplate) {
    this.folderNameTemplate = folderNameTemplate;
  }


  public OperationExtractionImages pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Used to define which page(s) should be used for the image&#39;s mode. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \&quot;1,5-6,9\&quot;). A blank value or \&quot;\\*\&quot; selects all pages of the PDF document.
   * @return pages
   **/
  @Nullable
  @Schema(name = "Used to define which page(s) should be used for the image's mode. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). A blank value or \"\\*\" selects all pages of the PDF document.")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationExtractionImages operationExtractionImages = (OperationExtractionImages) o;
    return Objects.equals(this.fallbackFormat, operationExtractionImages.fallbackFormat) &&
        Objects.equals(this.fileFormat, operationExtractionImages.fileFormat) &&
        Objects.equals(this.fileNameTemplate, operationExtractionImages.fileNameTemplate) &&
        Objects.equals(this.folderNameTemplate, operationExtractionImages.folderNameTemplate) &&
        Objects.equals(this.pages, operationExtractionImages.pages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fallbackFormat, fileFormat, fileNameTemplate, folderNameTemplate, pages);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationExtractionImages {\n");
    sb.append("    fallbackFormat: ").append(toIndentedString(fallbackFormat)).append("\n");
    sb.append("    fileFormat: ").append(toIndentedString(fileFormat)).append("\n");
    sb.append("    fileNameTemplate: ").append(toIndentedString(fileNameTemplate)).append("\n");
    sb.append("    folderNameTemplate: ").append(toIndentedString(folderNameTemplate)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
