/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The add element can be used to define one or multiple annotations, that shall be added to the document.
 */
@Schema(description = "The add element can be used to define one or multiple annotations, that shall be added to the document.")
@JsonPropertyOrder({
  OperationAddToolboxAnnotation.JSON_PROPERTY_CIRCLE,
  OperationAddToolboxAnnotation.JSON_PROPERTY_FREETEXT,
  OperationAddToolboxAnnotation.JSON_PROPERTY_LINE,
  OperationAddToolboxAnnotation.JSON_PROPERTY_MARKUP,
  OperationAddToolboxAnnotation.JSON_PROPERTY_REDACT,
  OperationAddToolboxAnnotation.JSON_PROPERTY_RUBBERSTAMP,
  OperationAddToolboxAnnotation.JSON_PROPERTY_SQUARE,
  OperationAddToolboxAnnotation.JSON_PROPERTY_TEXT
})
@JsonTypeName("Operation_AddToolboxAnnotation")

public class OperationAddToolboxAnnotation {
  public static final String JSON_PROPERTY_CIRCLE = "circle";
  private List<OperationCircleAnnotation> circle = null;

  public static final String JSON_PROPERTY_FREETEXT = "freetext";
  private List<OperationFreeTextAnnotation> freetext = null;

  public static final String JSON_PROPERTY_LINE = "line";
  private List<OperationLineAnnotation> line = null;

  public static final String JSON_PROPERTY_MARKUP = "markup";
  private List<OperationMarkupAnnotation> markup = null;

  public static final String JSON_PROPERTY_REDACT = "redact";
  private List<OperationRedactAnnotation> redact = null;

  public static final String JSON_PROPERTY_RUBBERSTAMP = "rubberstamp";
  private List<OperationRubberStampAnnotation> rubberstamp = null;

  public static final String JSON_PROPERTY_SQUARE = "square";
  private List<OperationSquareAnnotation> square = null;

  public static final String JSON_PROPERTY_TEXT = "text";
  private List<OperationTextAnnotation> text = null;

  public OperationAddToolboxAnnotation() {
  }

  public OperationAddToolboxAnnotation circle(List<OperationCircleAnnotation> circle) {
    
    this.circle = circle;
    return this;
  }

  public OperationAddToolboxAnnotation addCircleItem(OperationCircleAnnotation circleItem) {
    if (this.circle == null) {
        this.circle = new ArrayList<>();
    }
    this.circle.add(circleItem);
    return this;
  }

  /**
   * Get circle
   * @return circle
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CIRCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationCircleAnnotation> getCircle() {
    return circle;
  }


  @JsonProperty(JSON_PROPERTY_CIRCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCircle(List<OperationCircleAnnotation> circle) {
    this.circle = circle;
  }


  public OperationAddToolboxAnnotation freetext(List<OperationFreeTextAnnotation> freetext) {
    
    this.freetext = freetext;
    return this;
  }

  public OperationAddToolboxAnnotation addFreetextItem(OperationFreeTextAnnotation freetextItem) {
    if (this.freetext == null) {
        this.freetext = new ArrayList<>();
    }
    this.freetext.add(freetextItem);
    return this;
  }

  /**
   * Get freetext
   * @return freetext
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FREETEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationFreeTextAnnotation> getFreetext() {
    return freetext;
  }


  @JsonProperty(JSON_PROPERTY_FREETEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFreetext(List<OperationFreeTextAnnotation> freetext) {
    this.freetext = freetext;
  }


  public OperationAddToolboxAnnotation line(List<OperationLineAnnotation> line) {
    
    this.line = line;
    return this;
  }

  public OperationAddToolboxAnnotation addLineItem(OperationLineAnnotation lineItem) {
    if (this.line == null) {
        this.line = new ArrayList<>();
    }
    this.line.add(lineItem);
    return this;
  }

  /**
   * Get line
   * @return line
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationLineAnnotation> getLine() {
    return line;
  }


  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLine(List<OperationLineAnnotation> line) {
    this.line = line;
  }


  public OperationAddToolboxAnnotation markup(List<OperationMarkupAnnotation> markup) {
    
    this.markup = markup;
    return this;
  }

  public OperationAddToolboxAnnotation addMarkupItem(OperationMarkupAnnotation markupItem) {
    if (this.markup == null) {
        this.markup = new ArrayList<>();
    }
    this.markup.add(markupItem);
    return this;
  }

  /**
   * Get markup
   * @return markup
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationMarkupAnnotation> getMarkup() {
    return markup;
  }


  @JsonProperty(JSON_PROPERTY_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkup(List<OperationMarkupAnnotation> markup) {
    this.markup = markup;
  }


  public OperationAddToolboxAnnotation redact(List<OperationRedactAnnotation> redact) {
    
    this.redact = redact;
    return this;
  }

  public OperationAddToolboxAnnotation addRedactItem(OperationRedactAnnotation redactItem) {
    if (this.redact == null) {
        this.redact = new ArrayList<>();
    }
    this.redact.add(redactItem);
    return this;
  }

  /**
   * Get redact
   * @return redact
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationRedactAnnotation> getRedact() {
    return redact;
  }


  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedact(List<OperationRedactAnnotation> redact) {
    this.redact = redact;
  }


  public OperationAddToolboxAnnotation rubberstamp(List<OperationRubberStampAnnotation> rubberstamp) {
    
    this.rubberstamp = rubberstamp;
    return this;
  }

  public OperationAddToolboxAnnotation addRubberstampItem(OperationRubberStampAnnotation rubberstampItem) {
    if (this.rubberstamp == null) {
        this.rubberstamp = new ArrayList<>();
    }
    this.rubberstamp.add(rubberstampItem);
    return this;
  }

  /**
   * Get rubberstamp
   * @return rubberstamp
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_RUBBERSTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationRubberStampAnnotation> getRubberstamp() {
    return rubberstamp;
  }


  @JsonProperty(JSON_PROPERTY_RUBBERSTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRubberstamp(List<OperationRubberStampAnnotation> rubberstamp) {
    this.rubberstamp = rubberstamp;
  }


  public OperationAddToolboxAnnotation square(List<OperationSquareAnnotation> square) {
    
    this.square = square;
    return this;
  }

  public OperationAddToolboxAnnotation addSquareItem(OperationSquareAnnotation squareItem) {
    if (this.square == null) {
        this.square = new ArrayList<>();
    }
    this.square.add(squareItem);
    return this;
  }

  /**
   * Get square
   * @return square
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SQUARE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationSquareAnnotation> getSquare() {
    return square;
  }


  @JsonProperty(JSON_PROPERTY_SQUARE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSquare(List<OperationSquareAnnotation> square) {
    this.square = square;
  }


  public OperationAddToolboxAnnotation text(List<OperationTextAnnotation> text) {
    
    this.text = text;
    return this;
  }

  public OperationAddToolboxAnnotation addTextItem(OperationTextAnnotation textItem) {
    if (this.text == null) {
        this.text = new ArrayList<>();
    }
    this.text.add(textItem);
    return this;
  }

  /**
   * Get text
   * @return text
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationTextAnnotation> getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(List<OperationTextAnnotation> text) {
    this.text = text;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationAddToolboxAnnotation operationAddToolboxAnnotation = (OperationAddToolboxAnnotation) o;
    return Objects.equals(this.circle, operationAddToolboxAnnotation.circle) &&
        Objects.equals(this.freetext, operationAddToolboxAnnotation.freetext) &&
        Objects.equals(this.line, operationAddToolboxAnnotation.line) &&
        Objects.equals(this.markup, operationAddToolboxAnnotation.markup) &&
        Objects.equals(this.redact, operationAddToolboxAnnotation.redact) &&
        Objects.equals(this.rubberstamp, operationAddToolboxAnnotation.rubberstamp) &&
        Objects.equals(this.square, operationAddToolboxAnnotation.square) &&
        Objects.equals(this.text, operationAddToolboxAnnotation.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(circle, freetext, line, markup, redact, rubberstamp, square, text);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationAddToolboxAnnotation {\n");
    sb.append("    circle: ").append(toIndentedString(circle)).append("\n");
    sb.append("    freetext: ").append(toIndentedString(freetext)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("    markup: ").append(toIndentedString(markup)).append("\n");
    sb.append("    redact: ").append(toIndentedString(redact)).append("\n");
    sb.append("    rubberstamp: ").append(toIndentedString(rubberstamp)).append("\n");
    sb.append("    square: ").append(toIndentedString(square)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
