/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Summarizes structural information and settings for the PDF document.
 */
@Schema(description = "Summarizes structural information and settings for the PDF document.")
@JsonPropertyOrder({
  MetadataInformation.JSON_PROPERTY_ATTACHMENTS,
  MetadataInformation.JSON_PROPERTY_DESCRIPTION,
  MetadataInformation.JSON_PROPERTY_DOC_M_D_P,
  MetadataInformation.JSON_PROPERTY_ENCRYPTED,
  MetadataInformation.JSON_PROPERTY_FILE_SIZE,
  MetadataInformation.JSON_PROPERTY_FORM_TYPE,
  MetadataInformation.JSON_PROPERTY_INITIAL_PAGE,
  MetadataInformation.JSON_PROPERTY_INITIAL_VIEW,
  MetadataInformation.JSON_PROPERTY_LANGUAGE,
  MetadataInformation.JSON_PROPERTY_MAGNIFICATION,
  MetadataInformation.JSON_PROPERTY_MAGNIFICATION_ZOOM,
  MetadataInformation.JSON_PROPERTY_OBJECT_KEY,
  MetadataInformation.JSON_PROPERTY_PAGE_LAYOUT,
  MetadataInformation.JSON_PROPERTY_PAGES,
  MetadataInformation.JSON_PROPERTY_PDFA,
  MetadataInformation.JSON_PROPERTY_PORTFOLIO,
  MetadataInformation.JSON_PROPERTY_SIGNATURES,
  MetadataInformation.JSON_PROPERTY_VERSION,
  MetadataInformation.JSON_PROPERTY_VIEWER_PREFERENCES
})
@JsonTypeName("Metadata_Information")

public class MetadataInformation {
  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  private Integer attachments = 0;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private MetadataDescription description;

  /**
   * A document \&quot;Modification Detection and Prevention\&quot; may be set, that defines which modifications of the document are allowed and which modifications would render the signature invalid.  *   none &#x3D; The document is unprotected - modify it as you please. *   noChangesAllowed &#x3D; Any modifications of the document would render the signatures invalid. *   formFillingSignatures &#x3D; You may fill in forms and further sign the document. *   formFillingSignaturesAndAnnotations &#x3D; Form filling, signing and adding annotations are allowed.
   */
  public enum DocMDPEnum {
    NONE(String.valueOf("none")),
    
    NO_CHANGES_ALLOWED(String.valueOf("noChangesAllowed")),
    
    FORM_FILLING_SIGNATURES(String.valueOf("formFillingSignatures")),
    
    FORM_FILLING_SIGNATURES_ANNOTATIONS(String.valueOf("formFillingSignaturesAnnotations"));

    private String value;

    DocMDPEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DocMDPEnum fromValue(String value) {
      for (DocMDPEnum b : DocMDPEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DOC_M_D_P = "docMDP";
  private DocMDPEnum docMDP = DocMDPEnum.NONE;

  public static final String JSON_PROPERTY_ENCRYPTED = "encrypted";
  private Boolean encrypted = false;

  public static final String JSON_PROPERTY_FILE_SIZE = "fileSize";
  private Long fileSize = 0l;

  /**
   * When set to another value than \&quot;none\&quot;, the document does contain a PDF form in the hereby given format.  *   none &#x3D; The document does not contain a form. *   acroForm &#x3D; The document contains a standard PDF Acroform. *   staticXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with a fixed layout (static). *   dynamicXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with an adaptable/interactive layout (dynamic).
   */
  public enum FormTypeEnum {
    NONE(String.valueOf("none")),
    
    ACRO_FORM(String.valueOf("acroForm")),
    
    STATIC_XFA(String.valueOf("staticXFA")),
    
    DYNAMIC_XFA(String.valueOf("dynamicXFA"));

    private String value;

    FormTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FormTypeEnum fromValue(String value) {
      for (FormTypeEnum b : FormTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FORM_TYPE = "formType";
  private FormTypeEnum formType = FormTypeEnum.NONE;

  public static final String JSON_PROPERTY_INITIAL_PAGE = "initialPage";
  private Integer initialPage = 1;

  /**
   * Defines which sub-windows will be opened when the PDF document is opened.  *   none &#x3D; No special view *   outlines &#x3D; Opens the \&quot;Bookmarks\&quot; tab *   thumbnails &#x3D; Opens the \&quot;Thumbnails\&quot; tab *   fullscreen &#x3D; Opens the document in full screen mode
   */
  public enum InitialViewEnum {
    NONE(String.valueOf("none")),
    
    OUTLINES(String.valueOf("outlines")),
    
    THUMBNAILS(String.valueOf("thumbnails")),
    
    FULLSCREEN(String.valueOf("fullscreen")),
    
    LAYERS(String.valueOf("layers")),
    
    ATTACHMENTS(String.valueOf("attachments"));

    private String value;

    InitialViewEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InitialViewEnum fromValue(String value) {
      for (InitialViewEnum b : InitialViewEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INITIAL_VIEW = "initialView";
  private InitialViewEnum initialView = InitialViewEnum.NONE;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language = "";

  /**
   * The initial page zoom settings of a document. When opening the document in a Reader, this zoom settings shall be used.  *   none &#x3D; Uses the application&#39;s default view. *   fitWidth &#x3D; Page width. *   fitPage &#x3D; Page dimensions. *   fitHeight &#x3D; Page height. *   fitVisible &#x3D; Page content width. *   fitActual &#x3D; Uses the original page dimensions (100% zoom factor). *   zoom &#x3D; Sets an explicit magnification value.
   */
  public enum MagnificationEnum {
    NONE(String.valueOf("none")),
    
    FIT_WIDTH(String.valueOf("fitWidth")),
    
    FIT_VISIBLE(String.valueOf("fitVisible")),
    
    FIT_HEIGHT(String.valueOf("fitHeight")),
    
    FIT_PAGE(String.valueOf("fitPage")),
    
    FIT_ACTUAL(String.valueOf("fitActual")),
    
    ZOOM(String.valueOf("zoom"));

    private String value;

    MagnificationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MagnificationEnum fromValue(String value) {
      for (MagnificationEnum b : MagnificationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAGNIFICATION = "magnification";
  private MagnificationEnum magnification = MagnificationEnum.FIT_VISIBLE;

  public static final String JSON_PROPERTY_MAGNIFICATION_ZOOM = "magnificationZoom";
  private Integer magnificationZoom = 100;

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  /**
   * The set initial page layout of a document. When opening the document in a Reader, this layout shall be selected to display pages.  *   singlePage &#x3D; One page at a time. *   oneColumn &#x3D; One continuous column of pages. *   twoColumnLeft &#x3D; The pages in two columns, with odd-numbered pages on the left. *   twoColumnRight &#x3D; The pages in two columns, with odd-numbered pages on the right. *   twoPageLeft &#x3D; Display the pages two at a time, with odd-numbered pages on the left. *   twoPageRight &#x3D; Display the pages two at a time, with odd-numbered pages on the right.
   */
  public enum PageLayoutEnum {
    SINGLE_PAGE(String.valueOf("singlePage")),
    
    ONE_COLUMN(String.valueOf("oneColumn")),
    
    TWO_COLUMN_LEFT(String.valueOf("twoColumnLeft")),
    
    TWO_COLUMN_RIGHT(String.valueOf("twoColumnRight")),
    
    TWO_PAGE_LEFT(String.valueOf("twoPageLeft")),
    
    TWO_PAGE_RIGHT(String.valueOf("twoPageRight"));

    private String value;

    PageLayoutEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PageLayoutEnum fromValue(String value) {
      for (PageLayoutEnum b : PageLayoutEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAGE_LAYOUT = "pageLayout";
  private PageLayoutEnum pageLayout = PageLayoutEnum.SINGLE_PAGE;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private Integer pages = 0;

  public static final String JSON_PROPERTY_PDFA = "pdfa";
  private MetadataPdfa pdfa;

  public static final String JSON_PROPERTY_PORTFOLIO = "portfolio";
  private Boolean portfolio = false;

  public static final String JSON_PROPERTY_SIGNATURES = "signatures";
  private Integer signatures = 0;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version = "";

  public static final String JSON_PROPERTY_VIEWER_PREFERENCES = "viewerPreferences";
  private MetadataViewerPreferences viewerPreferences;

  public MetadataInformation() {
  }

  public MetadataInformation attachments(Integer attachments) {
    
    this.attachments = attachments;
    return this;
  }

  /**
   * The number of attachments contained in the document.
   * minimum: 0
   * @return attachments
   **/
  @Nullable
  @Schema(name = "The number of attachments contained in the document.")
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(Integer attachments) {
    this.attachments = attachments;
  }


  public MetadataInformation description(MetadataDescription description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataDescription getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(MetadataDescription description) {
    this.description = description;
  }


  public MetadataInformation docMDP(DocMDPEnum docMDP) {
    
    this.docMDP = docMDP;
    return this;
  }

  /**
   * A document \&quot;Modification Detection and Prevention\&quot; may be set, that defines which modifications of the document are allowed and which modifications would render the signature invalid.  *   none &#x3D; The document is unprotected - modify it as you please. *   noChangesAllowed &#x3D; Any modifications of the document would render the signatures invalid. *   formFillingSignatures &#x3D; You may fill in forms and further sign the document. *   formFillingSignaturesAndAnnotations &#x3D; Form filling, signing and adding annotations are allowed.
   * @return docMDP
   **/
  @Nullable
  @Schema(name = "A document \"Modification Detection and Prevention\" may be set, that defines which modifications of the document are allowed and which modifications would render the signature invalid.  *   none = The document is unprotected - modify it as you please. *   noChangesAllowed = Any modifications of the document would render the signatures invalid. *   formFillingSignatures = You may fill in forms and further sign the document. *   formFillingSignaturesAndAnnotations = Form filling, signing and adding annotations are allowed.")
  @JsonProperty(JSON_PROPERTY_DOC_M_D_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocMDPEnum getDocMDP() {
    return docMDP;
  }


  @JsonProperty(JSON_PROPERTY_DOC_M_D_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocMDP(DocMDPEnum docMDP) {
    this.docMDP = docMDP;
  }


  public MetadataInformation encrypted(Boolean encrypted) {
    
    this.encrypted = encrypted;
    return this;
  }

  /**
   * This will be set to \&quot;true\&quot; for a document, that is either password protected or certificate encrypted.
   * @return encrypted
   **/
  @Nullable
  @Schema(name = "This will be set to \"true\" for a document, that is either password protected or certificate encrypted.")
  @JsonProperty(JSON_PROPERTY_ENCRYPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEncrypted() {
    return encrypted;
  }


  @JsonProperty(JSON_PROPERTY_ENCRYPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncrypted(Boolean encrypted) {
    this.encrypted = encrypted;
  }


  public MetadataInformation fileSize(Long fileSize) {
    
    this.fileSize = fileSize;
    return this;
  }

  /**
   * The byte size of the document.
   * minimum: 0
   * maximum: 9223372036854775807
   * @return fileSize
   **/
  @Nullable
  @Schema(name = "The byte size of the document.")
  @JsonProperty(JSON_PROPERTY_FILE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFileSize() {
    return fileSize;
  }


  @JsonProperty(JSON_PROPERTY_FILE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }


  public MetadataInformation formType(FormTypeEnum formType) {
    
    this.formType = formType;
    return this;
  }

  /**
   * When set to another value than \&quot;none\&quot;, the document does contain a PDF form in the hereby given format.  *   none &#x3D; The document does not contain a form. *   acroForm &#x3D; The document contains a standard PDF Acroform. *   staticXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with a fixed layout (static). *   dynamicXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with an adaptable/interactive layout (dynamic).
   * @return formType
   **/
  @Nullable
  @Schema(name = "When set to another value than \"none\", the document does contain a PDF form in the hereby given format.  *   none = The document does not contain a form. *   acroForm = The document contains a standard PDF Acroform. *   staticXFA = The document contains a \"XML Forms Architecture\" form with a fixed layout (static). *   dynamicXFA = The document contains a \"XML Forms Architecture\" form with an adaptable/interactive layout (dynamic).")
  @JsonProperty(JSON_PROPERTY_FORM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FormTypeEnum getFormType() {
    return formType;
  }


  @JsonProperty(JSON_PROPERTY_FORM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormType(FormTypeEnum formType) {
    this.formType = formType;
  }


  public MetadataInformation initialPage(Integer initialPage) {
    
    this.initialPage = initialPage;
    return this;
  }

  /**
   * The first page, that shall be displayed when opening the document in a PDF Reader.
   * @return initialPage
   **/
  @Nullable
  @Schema(name = "The first page, that shall be displayed when opening the document in a PDF Reader.")
  @JsonProperty(JSON_PROPERTY_INITIAL_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getInitialPage() {
    return initialPage;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitialPage(Integer initialPage) {
    this.initialPage = initialPage;
  }


  public MetadataInformation initialView(InitialViewEnum initialView) {
    
    this.initialView = initialView;
    return this;
  }

  /**
   * Defines which sub-windows will be opened when the PDF document is opened.  *   none &#x3D; No special view *   outlines &#x3D; Opens the \&quot;Bookmarks\&quot; tab *   thumbnails &#x3D; Opens the \&quot;Thumbnails\&quot; tab *   fullscreen &#x3D; Opens the document in full screen mode
   * @return initialView
   **/
  @Nullable
  @Schema(name = "Defines which sub-windows will be opened when the PDF document is opened.  *   none = No special view *   outlines = Opens the \"Bookmarks\" tab *   thumbnails = Opens the \"Thumbnails\" tab *   fullscreen = Opens the document in full screen mode")
  @JsonProperty(JSON_PROPERTY_INITIAL_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InitialViewEnum getInitialView() {
    return initialView;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_VIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitialView(InitialViewEnum initialView) {
    this.initialView = initialView;
  }


  public MetadataInformation language(String language) {
    
    this.language = language;
    return this;
  }

  /**
   * The natural language of the document. This could either contain the language name or a language tag.
   * @return language
   **/
  @Nullable
  @Schema(name = "The natural language of the document. This could either contain the language name or a language tag.")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public MetadataInformation magnification(MagnificationEnum magnification) {
    
    this.magnification = magnification;
    return this;
  }

  /**
   * The initial page zoom settings of a document. When opening the document in a Reader, this zoom settings shall be used.  *   none &#x3D; Uses the application&#39;s default view. *   fitWidth &#x3D; Page width. *   fitPage &#x3D; Page dimensions. *   fitHeight &#x3D; Page height. *   fitVisible &#x3D; Page content width. *   fitActual &#x3D; Uses the original page dimensions (100% zoom factor). *   zoom &#x3D; Sets an explicit magnification value.
   * @return magnification
   **/
  @Nullable
  @Schema(name = "The initial page zoom settings of a document. When opening the document in a Reader, this zoom settings shall be used.  *   none = Uses the application's default view. *   fitWidth = Page width. *   fitPage = Page dimensions. *   fitHeight = Page height. *   fitVisible = Page content width. *   fitActual = Uses the original page dimensions (100% zoom factor). *   zoom = Sets an explicit magnification value.")
  @JsonProperty(JSON_PROPERTY_MAGNIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MagnificationEnum getMagnification() {
    return magnification;
  }


  @JsonProperty(JSON_PROPERTY_MAGNIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMagnification(MagnificationEnum magnification) {
    this.magnification = magnification;
  }


  public MetadataInformation magnificationZoom(Integer magnificationZoom) {
    
    this.magnificationZoom = magnificationZoom;
    return this;
  }

  /**
   * If a magnification \&quot;zoom\&quot; is selected for this document, this is the actual percentage the pages of the document shall be zoomed to, when opening the document in a PDF Reader.
   * minimum: 0
   * @return magnificationZoom
   **/
  @Nullable
  @Schema(name = "If a magnification \"zoom\" is selected for this document, this is the actual percentage the pages of the document shall be zoomed to, when opening the document in a PDF Reader.")
  @JsonProperty(JSON_PROPERTY_MAGNIFICATION_ZOOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMagnificationZoom() {
    return magnificationZoom;
  }


  @JsonProperty(JSON_PROPERTY_MAGNIFICATION_ZOOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMagnificationZoom(Integer magnificationZoom) {
    this.magnificationZoom = magnificationZoom;
  }


  public MetadataInformation objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the document&#39;s catalog. (root)  **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the document's catalog. (root)  **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataInformation pageLayout(PageLayoutEnum pageLayout) {
    
    this.pageLayout = pageLayout;
    return this;
  }

  /**
   * The set initial page layout of a document. When opening the document in a Reader, this layout shall be selected to display pages.  *   singlePage &#x3D; One page at a time. *   oneColumn &#x3D; One continuous column of pages. *   twoColumnLeft &#x3D; The pages in two columns, with odd-numbered pages on the left. *   twoColumnRight &#x3D; The pages in two columns, with odd-numbered pages on the right. *   twoPageLeft &#x3D; Display the pages two at a time, with odd-numbered pages on the left. *   twoPageRight &#x3D; Display the pages two at a time, with odd-numbered pages on the right.
   * @return pageLayout
   **/
  @Nullable
  @Schema(name = "The set initial page layout of a document. When opening the document in a Reader, this layout shall be selected to display pages.  *   singlePage = One page at a time. *   oneColumn = One continuous column of pages. *   twoColumnLeft = The pages in two columns, with odd-numbered pages on the left. *   twoColumnRight = The pages in two columns, with odd-numbered pages on the right. *   twoPageLeft = Display the pages two at a time, with odd-numbered pages on the left. *   twoPageRight = Display the pages two at a time, with odd-numbered pages on the right.")
  @JsonProperty(JSON_PROPERTY_PAGE_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PageLayoutEnum getPageLayout() {
    return pageLayout;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageLayout(PageLayoutEnum pageLayout) {
    this.pageLayout = pageLayout;
  }


  public MetadataInformation pages(Integer pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * The number of pages contained in the document.
   * minimum: 0
   * @return pages
   **/
  @Nullable
  @Schema(name = "The number of pages contained in the document.")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(Integer pages) {
    this.pages = pages;
  }


  public MetadataInformation pdfa(MetadataPdfa pdfa) {
    
    this.pdfa = pdfa;
    return this;
  }

  /**
   * Get pdfa
   * @return pdfa
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_PDFA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataPdfa getPdfa() {
    return pdfa;
  }


  @JsonProperty(JSON_PROPERTY_PDFA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPdfa(MetadataPdfa pdfa) {
    this.pdfa = pdfa;
  }


  public MetadataInformation portfolio(Boolean portfolio) {
    
    this.portfolio = portfolio;
    return this;
  }

  /**
   * Will be set to \&quot;true\&quot; for a \&quot;PDF collection\&quot; (Portfolio), that serves as the container for other documents.
   * @return portfolio
   **/
  @Nullable
  @Schema(name = "Will be set to \"true\" for a \"PDF collection\" (Portfolio), that serves as the container for other documents.")
  @JsonProperty(JSON_PROPERTY_PORTFOLIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPortfolio() {
    return portfolio;
  }


  @JsonProperty(JSON_PROPERTY_PORTFOLIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPortfolio(Boolean portfolio) {
    this.portfolio = portfolio;
  }


  public MetadataInformation signatures(Integer signatures) {
    
    this.signatures = signatures;
    return this;
  }

  /**
   * The number of signatures contained in the document.
   * @return signatures
   **/
  @Nullable
  @Schema(name = "The number of signatures contained in the document.")
  @JsonProperty(JSON_PROPERTY_SIGNATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSignatures() {
    return signatures;
  }


  @JsonProperty(JSON_PROPERTY_SIGNATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatures(Integer signatures) {
    this.signatures = signatures;
  }


  public MetadataInformation version(String version) {
    
    this.version = version;
    return this;
  }

  /**
   * The version name of the PDF standard the document claims compatibility with.
   * @return version
   **/
  @Nullable
  @Schema(name = "The version name of the PDF standard the document claims compatibility with.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(String version) {
    this.version = version;
  }


  public MetadataInformation viewerPreferences(MetadataViewerPreferences viewerPreferences) {
    
    this.viewerPreferences = viewerPreferences;
    return this;
  }

  /**
   * Get viewerPreferences
   * @return viewerPreferences
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_VIEWER_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataViewerPreferences getViewerPreferences() {
    return viewerPreferences;
  }


  @JsonProperty(JSON_PROPERTY_VIEWER_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setViewerPreferences(MetadataViewerPreferences viewerPreferences) {
    this.viewerPreferences = viewerPreferences;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataInformation metadataInformation = (MetadataInformation) o;
    return Objects.equals(this.attachments, metadataInformation.attachments) &&
        Objects.equals(this.description, metadataInformation.description) &&
        Objects.equals(this.docMDP, metadataInformation.docMDP) &&
        Objects.equals(this.encrypted, metadataInformation.encrypted) &&
        Objects.equals(this.fileSize, metadataInformation.fileSize) &&
        Objects.equals(this.formType, metadataInformation.formType) &&
        Objects.equals(this.initialPage, metadataInformation.initialPage) &&
        Objects.equals(this.initialView, metadataInformation.initialView) &&
        Objects.equals(this.language, metadataInformation.language) &&
        Objects.equals(this.magnification, metadataInformation.magnification) &&
        Objects.equals(this.magnificationZoom, metadataInformation.magnificationZoom) &&
        Objects.equals(this.objectKey, metadataInformation.objectKey) &&
        Objects.equals(this.pageLayout, metadataInformation.pageLayout) &&
        Objects.equals(this.pages, metadataInformation.pages) &&
        Objects.equals(this.pdfa, metadataInformation.pdfa) &&
        Objects.equals(this.portfolio, metadataInformation.portfolio) &&
        Objects.equals(this.signatures, metadataInformation.signatures) &&
        Objects.equals(this.version, metadataInformation.version) &&
        Objects.equals(this.viewerPreferences, metadataInformation.viewerPreferences);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attachments, description, docMDP, encrypted, fileSize, formType, initialPage, initialView, language, magnification, magnificationZoom, objectKey, pageLayout, pages, pdfa, portfolio, signatures, version, viewerPreferences);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataInformation {\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    docMDP: ").append(toIndentedString(docMDP)).append("\n");
    sb.append("    encrypted: ").append(toIndentedString(encrypted)).append("\n");
    sb.append("    fileSize: ").append(toIndentedString(fileSize)).append("\n");
    sb.append("    formType: ").append(toIndentedString(formType)).append("\n");
    sb.append("    initialPage: ").append(toIndentedString(initialPage)).append("\n");
    sb.append("    initialView: ").append(toIndentedString(initialView)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    magnification: ").append(toIndentedString(magnification)).append("\n");
    sb.append("    magnificationZoom: ").append(toIndentedString(magnificationZoom)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    pageLayout: ").append(toIndentedString(pageLayout)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    pdfa: ").append(toIndentedString(pdfa)).append("\n");
    sb.append("    portfolio: ").append(toIndentedString(portfolio)).append("\n");
    sb.append("    signatures: ").append(toIndentedString(signatures)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    viewerPreferences: ").append(toIndentedString(viewerPreferences)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
