/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * A document element that describes the content and properties of the PDF document as metadata.
 */
@Schema(description = "A document element that describes the content and properties of the PDF document as metadata.")
@JsonPropertyOrder({
  MetadataDocument.JSON_PROPERTY_ANNOTATIONS,
  MetadataDocument.JSON_PROPERTY_ATTACHMENTS,
  MetadataDocument.JSON_PROPERTY_BACKGROUNDS,
  MetadataDocument.JSON_PROPERTY_FOLDERS,
  MetadataDocument.JSON_PROPERTY_FORM,
  MetadataDocument.JSON_PROPERTY_HEADERS_FOOTERS,
  MetadataDocument.JSON_PROPERTY_IMAGES,
  MetadataDocument.JSON_PROPERTY_INFORMATION,
  MetadataDocument.JSON_PROPERTY_PAGES,
  MetadataDocument.JSON_PROPERTY_SECURITY,
  MetadataDocument.JSON_PROPERTY_SIGNATURES,
  MetadataDocument.JSON_PROPERTY_TRANSITIONS
})
@JsonTypeName("Metadata_Document")

public class MetadataDocument {
  public static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
  private MetadataAnnotationsDocument annotations;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  private MetadataAttachmentsDocument attachments;

  public static final String JSON_PROPERTY_BACKGROUNDS = "backgrounds";
  private MetadataBackgroundsDocument backgrounds;

  public static final String JSON_PROPERTY_FOLDERS = "folders";
  private MetadataFoldersDocument folders;

  public static final String JSON_PROPERTY_FORM = "form";
  private MetadataFormDocument form;

  public static final String JSON_PROPERTY_HEADERS_FOOTERS = "headersFooters";
  private MetadataHeadersFootersDocument headersFooters;

  public static final String JSON_PROPERTY_IMAGES = "images";
  private MetadataImagesDocument images;

  public static final String JSON_PROPERTY_INFORMATION = "information";
  private MetadataInformation information;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private MetadataPagesDocument pages;

  public static final String JSON_PROPERTY_SECURITY = "security";
  private MetadataSecurity security;

  public static final String JSON_PROPERTY_SIGNATURES = "signatures";
  private MetadataSignaturesDocument signatures;

  public static final String JSON_PROPERTY_TRANSITIONS = "transitions";
  private MetadataTransitionsDocument transitions;

  public MetadataDocument() {
  }

  public MetadataDocument annotations(MetadataAnnotationsDocument annotations) {
    
    this.annotations = annotations;
    return this;
  }

  /**
   * Get annotations
   * @return annotations
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataAnnotationsDocument getAnnotations() {
    return annotations;
  }


  @JsonProperty(JSON_PROPERTY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnotations(MetadataAnnotationsDocument annotations) {
    this.annotations = annotations;
  }


  public MetadataDocument attachments(MetadataAttachmentsDocument attachments) {
    
    this.attachments = attachments;
    return this;
  }

  /**
   * Get attachments
   * @return attachments
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataAttachmentsDocument getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(MetadataAttachmentsDocument attachments) {
    this.attachments = attachments;
  }


  public MetadataDocument backgrounds(MetadataBackgroundsDocument backgrounds) {
    
    this.backgrounds = backgrounds;
    return this;
  }

  /**
   * Get backgrounds
   * @return backgrounds
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_BACKGROUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataBackgroundsDocument getBackgrounds() {
    return backgrounds;
  }


  @JsonProperty(JSON_PROPERTY_BACKGROUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBackgrounds(MetadataBackgroundsDocument backgrounds) {
    this.backgrounds = backgrounds;
  }


  public MetadataDocument folders(MetadataFoldersDocument folders) {
    
    this.folders = folders;
    return this;
  }

  /**
   * Get folders
   * @return folders
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FOLDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataFoldersDocument getFolders() {
    return folders;
  }


  @JsonProperty(JSON_PROPERTY_FOLDERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFolders(MetadataFoldersDocument folders) {
    this.folders = folders;
  }


  public MetadataDocument form(MetadataFormDocument form) {
    
    this.form = form;
    return this;
  }

  /**
   * Get form
   * @return form
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataFormDocument getForm() {
    return form;
  }


  @JsonProperty(JSON_PROPERTY_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForm(MetadataFormDocument form) {
    this.form = form;
  }


  public MetadataDocument headersFooters(MetadataHeadersFootersDocument headersFooters) {
    
    this.headersFooters = headersFooters;
    return this;
  }

  /**
   * Get headersFooters
   * @return headersFooters
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_HEADERS_FOOTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataHeadersFootersDocument getHeadersFooters() {
    return headersFooters;
  }


  @JsonProperty(JSON_PROPERTY_HEADERS_FOOTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeadersFooters(MetadataHeadersFootersDocument headersFooters) {
    this.headersFooters = headersFooters;
  }


  public MetadataDocument images(MetadataImagesDocument images) {
    
    this.images = images;
    return this;
  }

  /**
   * Get images
   * @return images
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataImagesDocument getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(MetadataImagesDocument images) {
    this.images = images;
  }


  public MetadataDocument information(MetadataInformation information) {
    
    this.information = information;
    return this;
  }

  /**
   * Get information
   * @return information
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataInformation getInformation() {
    return information;
  }


  @JsonProperty(JSON_PROPERTY_INFORMATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInformation(MetadataInformation information) {
    this.information = information;
  }


  public MetadataDocument pages(MetadataPagesDocument pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Get pages
   * @return pages
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataPagesDocument getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(MetadataPagesDocument pages) {
    this.pages = pages;
  }


  public MetadataDocument security(MetadataSecurity security) {
    
    this.security = security;
    return this;
  }

  /**
   * Get security
   * @return security
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_SECURITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataSecurity getSecurity() {
    return security;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSecurity(MetadataSecurity security) {
    this.security = security;
  }


  public MetadataDocument signatures(MetadataSignaturesDocument signatures) {
    
    this.signatures = signatures;
    return this;
  }

  /**
   * Get signatures
   * @return signatures
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SIGNATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataSignaturesDocument getSignatures() {
    return signatures;
  }


  @JsonProperty(JSON_PROPERTY_SIGNATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatures(MetadataSignaturesDocument signatures) {
    this.signatures = signatures;
  }


  public MetadataDocument transitions(MetadataTransitionsDocument transitions) {
    
    this.transitions = transitions;
    return this;
  }

  /**
   * Get transitions
   * @return transitions
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataTransitionsDocument getTransitions() {
    return transitions;
  }


  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransitions(MetadataTransitionsDocument transitions) {
    this.transitions = transitions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataDocument metadataDocument = (MetadataDocument) o;
    return Objects.equals(this.annotations, metadataDocument.annotations) &&
        Objects.equals(this.attachments, metadataDocument.attachments) &&
        Objects.equals(this.backgrounds, metadataDocument.backgrounds) &&
        Objects.equals(this.folders, metadataDocument.folders) &&
        Objects.equals(this.form, metadataDocument.form) &&
        Objects.equals(this.headersFooters, metadataDocument.headersFooters) &&
        Objects.equals(this.images, metadataDocument.images) &&
        Objects.equals(this.information, metadataDocument.information) &&
        Objects.equals(this.pages, metadataDocument.pages) &&
        Objects.equals(this.security, metadataDocument.security) &&
        Objects.equals(this.signatures, metadataDocument.signatures) &&
        Objects.equals(this.transitions, metadataDocument.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annotations, attachments, backgrounds, folders, form, headersFooters, images, information, pages, security, signatures, transitions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataDocument {\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    backgrounds: ").append(toIndentedString(backgrounds)).append("\n");
    sb.append("    folders: ").append(toIndentedString(folders)).append("\n");
    sb.append("    form: ").append(toIndentedString(form)).append("\n");
    sb.append("    headersFooters: ").append(toIndentedString(headersFooters)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    information: ").append(toIndentedString(information)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    security: ").append(toIndentedString(security)).append("\n");
    sb.append("    signatures: ").append(toIndentedString(signatures)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
