/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.2 (2025-07-24T10:43:19Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The result of a used executable application.
 */
@Schema(description = "The result of a used executable application.")
@JsonPropertyOrder({
  AdminExecutableResult.JSON_PROPERTY_APPLICATION_NAME,
  AdminExecutableResult.JSON_PROPERTY_COMMAND_LINE,
  AdminExecutableResult.JSON_PROPERTY_CONSOLE_OUTPUT,
  AdminExecutableResult.JSON_PROPERTY_EXIT_CODE,
  AdminExecutableResult.JSON_PROPERTY_IS_SUCCESSFUL,
  AdminExecutableResult.JSON_PROPERTY_MESSAGE
})
@JsonTypeName("Admin_ExecutableResult")

public class AdminExecutableResult {
  public static final String JSON_PROPERTY_APPLICATION_NAME = "applicationName";
  private String applicationName = "";

  public static final String JSON_PROPERTY_COMMAND_LINE = "commandLine";
  private List<String> commandLine = null;

  public static final String JSON_PROPERTY_CONSOLE_OUTPUT = "consoleOutput";
  private List<String> consoleOutput = null;

  public static final String JSON_PROPERTY_EXIT_CODE = "exitCode";
  private Integer exitCode = 0;

  public static final String JSON_PROPERTY_IS_SUCCESSFUL = "isSuccessful";
  private Boolean isSuccessful = false;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message = "";

  public AdminExecutableResult() {
  }

  public AdminExecutableResult applicationName(String applicationName) {
    
    this.applicationName = applicationName;
    return this;
  }

  /**
   * The name of the executed application.
   * @return applicationName
   **/
  @Nullable
  @Schema(name = "The name of the executed application.")
  @JsonProperty(JSON_PROPERTY_APPLICATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApplicationName() {
    return applicationName;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }


  public AdminExecutableResult commandLine(List<String> commandLine) {
    
    this.commandLine = commandLine;
    return this;
  }

  public AdminExecutableResult addCommandLineItem(String commandLineItem) {
    if (this.commandLine == null) {
        this.commandLine = new ArrayList<>();
    }
    this.commandLine.add(commandLineItem);
    return this;
  }

  /**
   * The commandline output created by the executed application.
   * @return commandLine
   **/
  @Nullable
  @Schema(name = "The commandline output created by the executed application.")
  @JsonProperty(JSON_PROPERTY_COMMAND_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCommandLine() {
    return commandLine;
  }


  @JsonProperty(JSON_PROPERTY_COMMAND_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommandLine(List<String> commandLine) {
    this.commandLine = commandLine;
  }


  public AdminExecutableResult consoleOutput(List<String> consoleOutput) {
    
    this.consoleOutput = consoleOutput;
    return this;
  }

  public AdminExecutableResult addConsoleOutputItem(String consoleOutputItem) {
    if (this.consoleOutput == null) {
        this.consoleOutput = new ArrayList<>();
    }
    this.consoleOutput.add(consoleOutputItem);
    return this;
  }

  /**
   * The console output created by the executed application.
   * @return consoleOutput
   **/
  @Nullable
  @Schema(name = "The console output created by the executed application.")
  @JsonProperty(JSON_PROPERTY_CONSOLE_OUTPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getConsoleOutput() {
    return consoleOutput;
  }


  @JsonProperty(JSON_PROPERTY_CONSOLE_OUTPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConsoleOutput(List<String> consoleOutput) {
    this.consoleOutput = consoleOutput;
  }


  public AdminExecutableResult exitCode(Integer exitCode) {
    
    this.exitCode = exitCode;
    return this;
  }

  /**
   * The application specific exit code. This is not a webPDF error code and is defined by the called application itself.
   * @return exitCode
   **/
  @Nullable
  @Schema(name = "The application specific exit code. This is not a webPDF error code and is defined by the called application itself.")
  @JsonProperty(JSON_PROPERTY_EXIT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExitCode() {
    return exitCode;
  }


  @JsonProperty(JSON_PROPERTY_EXIT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExitCode(Integer exitCode) {
    this.exitCode = exitCode;
  }


  public AdminExecutableResult isSuccessful(Boolean isSuccessful) {
    
    this.isSuccessful = isSuccessful;
    return this;
  }

  /**
   * When set to true, the execution has been successful.
   * @return isSuccessful
   **/
  @Nullable
  @Schema(name = "When set to true, the execution has been successful.")
  @JsonProperty(JSON_PROPERTY_IS_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsSuccessful() {
    return isSuccessful;
  }


  @JsonProperty(JSON_PROPERTY_IS_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsSuccessful(Boolean isSuccessful) {
    this.isSuccessful = isSuccessful;
  }


  public AdminExecutableResult message(String message) {
    
    this.message = message;
    return this;
  }

  /**
   * A message summarizing the execution result.
   * @return message
   **/
  @Nullable
  @Schema(name = "A message summarizing the execution result.")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminExecutableResult adminExecutableResult = (AdminExecutableResult) o;
    return Objects.equals(this.applicationName, adminExecutableResult.applicationName) &&
        Objects.equals(this.commandLine, adminExecutableResult.commandLine) &&
        Objects.equals(this.consoleOutput, adminExecutableResult.consoleOutput) &&
        Objects.equals(this.exitCode, adminExecutableResult.exitCode) &&
        Objects.equals(this.isSuccessful, adminExecutableResult.isSuccessful) &&
        Objects.equals(this.message, adminExecutableResult.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicationName, commandLine, consoleOutput, exitCode, isSuccessful, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminExecutableResult {\n");
    sb.append("    applicationName: ").append(toIndentedString(applicationName)).append("\n");
    sb.append("    commandLine: ").append(toIndentedString(commandLine)).append("\n");
    sb.append("    consoleOutput: ").append(toIndentedString(consoleOutput)).append("\n");
    sb.append("    exitCode: ").append(toIndentedString(exitCode)).append("\n");
    sb.append("    isSuccessful: ").append(toIndentedString(isSuccessful)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
