
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An element of this type represents the properties of a signature.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SignatureType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SignatureType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="reason" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="contact" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="location" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="date" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="filter" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subFilter" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureType")
public class SignatureType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the signature.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "objectKey")
    protected String objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the person or authority signing the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The reason for signing the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "reason")
    protected String reason;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The contact information provided by the signer.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "contact")
    protected String contact;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The location the document has been signed at.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "location")
    protected String location;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date the signature has been created.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "date")
    protected String date;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the preferred signature handler used for validation. (Adobe.PPKLite, EntrustPPKEF etc.)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "filter")
    protected String filter;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The encoding of the signature value, that shall also be used for validation. (adbe.x509.rsa_sha1, adbe.pkcs7.sha1, etc.)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "subFilter")
    protected String subFilter;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the signature.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getObjectKey() {
        if (objectKey == null) {
            return "";
        } else {
            return objectKey;
        }
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the person or authority signing the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The reason for signing the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getReason() {
        if (reason == null) {
            return "";
        } else {
            return reason;
        }
    }

    /**
     * Sets the value of the reason property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getReason()
     */
    public void setReason(String value) {
        this.reason = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The contact information provided by the signer.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContact() {
        if (contact == null) {
            return "";
        } else {
            return contact;
        }
    }

    /**
     * Sets the value of the contact property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getContact()
     */
    public void setContact(String value) {
        this.contact = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The location the document has been signed at.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocation() {
        if (location == null) {
            return "";
        } else {
            return location;
        }
    }

    /**
     * Sets the value of the location property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLocation()
     */
    public void setLocation(String value) {
        this.location = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The date the signature has been created.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDate() {
        if (date == null) {
            return "";
        } else {
            return date;
        }
    }

    /**
     * Sets the value of the date property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDate()
     */
    public void setDate(String value) {
        this.date = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The name of the preferred signature handler used for validation. (Adobe.PPKLite, EntrustPPKEF etc.)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFilter() {
        if (filter == null) {
            return "";
        } else {
            return filter;
        }
    }

    /**
     * Sets the value of the filter property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFilter()
     */
    public void setFilter(String value) {
        this.filter = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The encoding of the signature value, that shall also be used for validation. (adbe.x509.rsa_sha1, adbe.pkcs7.sha1, etc.)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubFilter() {
        if (subFilter == null) {
            return "";
        } else {
            return subFilter;
        }
    }

    /**
     * Sets the value of the subFilter property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubFilter()
     */
    public void setSubFilter(String value) {
        this.subFilter = value;
    }

}
