
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The algorithm used for encryption.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = The document is not encrypted.&lt;/li&gt;&lt;li&gt;aes = The document has been encrypted using the Advanced Encryption Standard.&lt;/li&gt;&lt;li&gt;rc4 = The document has been encrypted using the RC4 cipher.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for KeyAlgorithmType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="KeyAlgorithmType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="aes"/>
 *     <enumeration value="rc4"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "KeyAlgorithmType")
@XmlEnum
public enum KeyAlgorithmType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("aes")
    AES("aes"),
    @XmlEnumValue("rc4")
    RC_4("rc4");
    private final String value;

    KeyAlgorithmType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static KeyAlgorithmType fromValue(String v) {
        for (KeyAlgorithmType c: KeyAlgorithmType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
