
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An element of this type defines a background for a page of the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BackgroundContentType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BackgroundContentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="pieceInfo" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="absoluteScaling" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *                 <attribute name="scale" default="1">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="rotation" default="0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *                       <minInclusive value="0"/>
 *                       <maxInclusive value="360"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="opacity" default="1.0">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *                       <minInclusive value="0"/>
 *                       <maxInclusive value="1"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *                 <attribute name="color" type="{http://schema.webpdf.de/1.0/extraction/info}RgbColorType" default="#FFFFFF" />
 *                 <attribute name="alignment" type="{http://schema.webpdf.de/1.0/extraction/info}Alignment" default="top_left" />
 *                 <attribute name="horizOffset" type="{http://www.w3.org/2001/XMLSchema}float" default="0.0" />
 *                 <attribute name="vertOffset" type="{http://www.w3.org/2001/XMLSchema}float" default="0.0" />
 *                 <attribute name="unit" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="bounds" type="{http://schema.webpdf.de/1.0/extraction/info}RectangleType"/>
 *       </sequence>
 *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="onprint" default="true">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}boolean">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="onscreen" default="true">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}boolean">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="isImage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BackgroundContentType", propOrder = {
    "pieceInfo",
    "bounds"
})
public class BackgroundContentType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Properties listed in the Adobe piece info.&lt;/p&gt;
     * </pre>
     * 
     */
    protected BackgroundContentType.PieceInfo pieceInfo;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The bounding box of the background.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlElement(required = true)
    protected RectangleType bounds;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the background.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "objectKey")
    protected String objectKey;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page the background shall be set for.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "page")
    protected Integer page;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Whether the background shall be visible in printouts of the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "onprint")
    protected Boolean onprint;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Whether the background shall be visible in Readers.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "onscreen")
    protected Boolean onscreen;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to true, the background is using an image resource. (Otherwise it is unicolor)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "isImage")
    protected Boolean isImage;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Properties listed in the Adobe piece info.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link BackgroundContentType.PieceInfo }
     *     
     */
    public BackgroundContentType.PieceInfo getPieceInfo() {
        return pieceInfo;
    }

    /**
     * Sets the value of the pieceInfo property.
     * 
     * @param value
     *     allowed object is
     *     {@link BackgroundContentType.PieceInfo }
     *     
     * @see #getPieceInfo()
     */
    public void setPieceInfo(BackgroundContentType.PieceInfo value) {
        this.pieceInfo = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The bounding box of the background.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getBounds() {
        return bounds;
    }

    /**
     * Sets the value of the bounds property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getBounds()
     */
    public void setBounds(RectangleType value) {
        this.bounds = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The object ID of the background.&#13;
     * &#13;
     *                         &lt;b&gt;Info:&lt;/b&gt;&#13;
     *                         A PDF object ID consists of two numbers, where the first number selects the object's number and the second the "generation" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getObjectKey() {
        if (objectKey == null) {
            return "";
        } else {
            return objectKey;
        }
    }

    /**
     * Sets the value of the objectKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getObjectKey()
     */
    public void setObjectKey(String value) {
        this.objectKey = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The page the background shall be set for.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  0;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getPage()
     */
    public void setPage(Integer value) {
        this.page = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Whether the background shall be visible in printouts of the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isOnprint() {
        if (onprint == null) {
            return true;
        } else {
            return onprint;
        }
    }

    /**
     * Sets the value of the onprint property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isOnprint()
     */
    public void setOnprint(Boolean value) {
        this.onprint = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Whether the background shall be visible in Readers.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isOnscreen() {
        if (onscreen == null) {
            return true;
        } else {
            return onscreen;
        }
    }

    /**
     * Sets the value of the onscreen property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isOnscreen()
     */
    public void setOnscreen(Boolean value) {
        this.onscreen = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to true, the background is using an image resource. (Otherwise it is unicolor)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isIsImage() {
        if (isImage == null) {
            return false;
        } else {
            return isImage;
        }
    }

    /**
     * Sets the value of the isImage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isIsImage()
     */
    public void setIsImage(Boolean value) {
        this.isImage = value;
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="absoluteScaling" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *       <attribute name="scale" default="1">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="rotation" default="0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
     *             <minInclusive value="0"/>
     *             <maxInclusive value="360"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="opacity" default="1.0">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
     *             <minInclusive value="0"/>
     *             <maxInclusive value="1"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *       <attribute name="color" type="{http://schema.webpdf.de/1.0/extraction/info}RgbColorType" default="#FFFFFF" />
     *       <attribute name="alignment" type="{http://schema.webpdf.de/1.0/extraction/info}Alignment" default="top_left" />
     *       <attribute name="horizOffset" type="{http://www.w3.org/2001/XMLSchema}float" default="0.0" />
     *       <attribute name="vertOffset" type="{http://www.w3.org/2001/XMLSchema}float" default="0.0" />
     *       <attribute name="unit" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class PieceInfo {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to true the page shall be scaled relative to it's own original dimensions, when set to false, it shall be scaled relative to the page dimensions.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "absoluteScaling")
        protected Boolean absoluteScaling;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The scaling of the background.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "scale")
        protected Float scale;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The rotation of the background.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "rotation")
        protected Integer rotation;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The opacity of the background, as a percentage in the range 0.0 (fully transparent) to 1.0 (fully opaque).&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "opacity")
        protected Float opacity;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The color of a unicolor background.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "color")
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        protected String color;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Uses one of multiple preset positions in order to position the background on the page.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;custom = Disable the use of a preset position.&lt;/li&gt;&lt;li&gt;top_left = Positions the background in the top left corner.&lt;/li&gt;&lt;li&gt;top_center = Positions the background in the centre on the top margin.&lt;/li&gt;&lt;li&gt;top_right = Positions the background in the top right corner.&lt;/li&gt;&lt;li&gt;center_left = Positions the background at the centre of the page, to the left.&lt;/li&gt;&lt;li&gt;center_center = Positions the background at the centre of the page.&lt;/li&gt;&lt;li&gt;center_right = Positions the background at the centre of the page, to the right.&lt;/li&gt;&lt;li&gt;bottom_left = Positions the background in the bottom left corner.&lt;/li&gt;&lt;li&gt;bottom_center = Positions the background in the centre on the bottom margin.&lt;/li&gt;&lt;li&gt;bottom_right = Positions the background in the bottom right corner.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "alignment")
        protected Alignment alignment;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The horizontal offset in relation to the backgrounds bas position.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "horizOffset")
        protected Float horizOffset;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The vertical offset in relation to the backgrounds bas position.&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "vertOffset")
        protected Float vertOffset;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Adobe unit used to display offsets in readers. (millimeters, pica, point etc).&lt;/p&gt;
         * </pre>
         * 
         */
        @XmlAttribute(name = "unit")
        protected String unit;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When set to true the page shall be scaled relative to it's own original dimensions, when set to false, it shall be scaled relative to the page dimensions.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isAbsoluteScaling() {
            if (absoluteScaling == null) {
                return true;
            } else {
                return absoluteScaling;
            }
        }

        /**
         * Sets the value of the absoluteScaling property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         * @see #isAbsoluteScaling()
         */
        public void setAbsoluteScaling(Boolean value) {
            this.absoluteScaling = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The scaling of the background.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getScale() {
            if (scale == null) {
                return  1.0F;
            } else {
                return scale;
            }
        }

        /**
         * Sets the value of the scale property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getScale()
         */
        public void setScale(Float value) {
            this.scale = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The rotation of the background.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Integer }
         *     
         */
        public int getRotation() {
            if (rotation == null) {
                return  0;
            } else {
                return rotation;
            }
        }

        /**
         * Sets the value of the rotation property.
         * 
         * @param value
         *     allowed object is
         *     {@link Integer }
         *     
         * @see #getRotation()
         */
        public void setRotation(Integer value) {
            this.rotation = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The opacity of the background, as a percentage in the range 0.0 (fully transparent) to 1.0 (fully opaque).&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getOpacity() {
            if (opacity == null) {
                return  1.0F;
            } else {
                return opacity;
            }
        }

        /**
         * Sets the value of the opacity property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getOpacity()
         */
        public void setOpacity(Float value) {
            this.opacity = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The color of a unicolor background.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getColor() {
            if (color == null) {
                return "#FFFFFF";
            } else {
                return color;
            }
        }

        /**
         * Sets the value of the color property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getColor()
         */
        public void setColor(String value) {
            this.color = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Uses one of multiple preset positions in order to position the background on the page.&#13;
         *                                     &lt;ul&gt;&lt;li&gt;custom = Disable the use of a preset position.&lt;/li&gt;&lt;li&gt;top_left = Positions the background in the top left corner.&lt;/li&gt;&lt;li&gt;top_center = Positions the background in the centre on the top margin.&lt;/li&gt;&lt;li&gt;top_right = Positions the background in the top right corner.&lt;/li&gt;&lt;li&gt;center_left = Positions the background at the centre of the page, to the left.&lt;/li&gt;&lt;li&gt;center_center = Positions the background at the centre of the page.&lt;/li&gt;&lt;li&gt;center_right = Positions the background at the centre of the page, to the right.&lt;/li&gt;&lt;li&gt;bottom_left = Positions the background in the bottom left corner.&lt;/li&gt;&lt;li&gt;bottom_center = Positions the background in the centre on the bottom margin.&lt;/li&gt;&lt;li&gt;bottom_right = Positions the background in the bottom right corner.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Alignment }
         *     
         */
        public Alignment getAlignment() {
            if (alignment == null) {
                return Alignment.TOP_LEFT;
            } else {
                return alignment;
            }
        }

        /**
         * Sets the value of the alignment property.
         * 
         * @param value
         *     allowed object is
         *     {@link Alignment }
         *     
         * @see #getAlignment()
         */
        public void setAlignment(Alignment value) {
            this.alignment = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The horizontal offset in relation to the backgrounds bas position.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getHorizOffset() {
            if (horizOffset == null) {
                return  0.0F;
            } else {
                return horizOffset;
            }
        }

        /**
         * Sets the value of the horizOffset property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getHorizOffset()
         */
        public void setHorizOffset(Float value) {
            this.horizOffset = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The vertical offset in relation to the backgrounds bas position.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link Float }
         *     
         */
        public float getVertOffset() {
            if (vertOffset == null) {
                return  0.0F;
            } else {
                return vertOffset;
            }
        }

        /**
         * Sets the value of the vertOffset property.
         * 
         * @param value
         *     allowed object is
         *     {@link Float }
         *     
         * @see #getVertOffset()
         */
        public void setVertOffset(Float value) {
            this.vertOffset = value;
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Adobe unit used to display offsets in readers. (millimeters, pica, point etc).&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getUnit() {
            if (unit == null) {
                return "";
            } else {
                return unit;
            }
        }

        /**
         * Sets the value of the unit property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         * @see #getUnit()
         */
        public void setUnit(String value) {
            this.unit = value;
        }

    }

}
