/*
 * Decompiled with CFR 0.152.
 */
package net.wattpadpremium.filejumper.builders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.wattpadpremium.filejumper.JsonFileModification;
import net.wattpadpremium.filejumper.abstraction.JsonTask;

public class JsonFileCreator {
    private JsonObject jsonObject;
    private final File file;

    private JsonFileCreator(File file) {
        this.file = file;
        this.createMissingDirectories();
        try {
            String fileContent = Files.readString(file.toPath(), StandardCharsets.UTF_8);
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse(fileContent);
            if (jsonElement.isJsonObject()) {
                this.jsonObject = jsonElement.getAsJsonObject();
            }
            if (jsonElement.isJsonNull()) {
                this.jsonObject = new JsonObject();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void editWithTemplate(JsonTask runnable) {
        runnable.editTemplate(new JsonFileModification(this.jsonObject));
        this.saveToFile();
    }

    public static JsonFileCreator createJsonFile(File file) {
        return new JsonFileCreator(file);
    }

    private void saveToFile() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)this.jsonObject);
            Files.writeString(this.file.toPath(), (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createMissingDirectories() {
        if (!this.file.exists()) {
            String s = this.file.getParent();
            File folders = new File(s);
            if (!folders.exists()) {
                folders.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

