/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.wasdev.wlp.maven.plugins.ApplicationXmlDocument;
import net.wasdev.wlp.maven.plugins.applications.InstallAppMojoSupport;
import net.wasdev.wlp.maven.plugins.applications.LooseConfigData;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

@Mojo(name="install-apps", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class InstallAppsMojo
extends InstallAppMojoSupport {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter
    private String classifier;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        this.cleanupPreviousExecution();
        this.copyConfigFiles();
        this.exportParametersToXml();
        boolean installDependencies = false;
        boolean installProject = false;
        switch (this.getInstallAppPackages()) {
            case "all": {
                installDependencies = true;
                installProject = true;
                break;
            }
            case "dependencies": {
                installDependencies = true;
                break;
            }
            case "project": {
                installProject = true;
                break;
            }
            case "spring-boot-project": {
                this.installSpringBootApp();
                break;
            }
            default: {
                return;
            }
        }
        if (installDependencies) {
            this.installDependencies();
        }
        if (installProject) {
            this.installProject();
        }
        if (this.applicationXml.hasChildElements()) {
            this.log.warn((CharSequence)messages.getString("warn.install.app.add.configuration"));
            this.applicationXml.writeApplicationXmlDocument(this.serverDirectory);
        }
    }

    private void installSpringBootApp() throws Exception {
        File fatArchiveSrc = this.getFatArchiveSrc();
        if (!this.isFileExecutable(fatArchiveSrc)) {
            throw new MojoExecutionException(fatArchiveSrc.getCanonicalPath() + " file is not an executable archive. The repackage goal of the spring-boot-maven-plugin must be configured to run first in order to create the required executable archive.");
        }
        File thinArchiveTarget = this.getThinArchiveTarget(fatArchiveSrc);
        File libIndexCacheTarget = this.getLibIndexCacheTarget();
        Artifact artifact = this.project.getArtifact();
        artifact.setFile(thinArchiveTarget);
        this.validateAppConfig(artifact.getFile().getName(), artifact.getArtifactId(), true);
        this.invokeSpringBootUtilCommand(this.installDirectory, fatArchiveSrc.getCanonicalPath(), thinArchiveTarget.getCanonicalPath(), libIndexCacheTarget.getCanonicalPath());
    }

    private File getFatArchiveSrc() {
        String classifier;
        String string = classifier = this.classifier == null ? "" : this.classifier.trim();
        if (!classifier.isEmpty() && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + classifier + "." + this.getArtifactExtension());
    }

    private File getThinArchiveTarget(File archiveSrc) {
        String appsDirName = this.getAppsDirectory();
        File archiveTarget = null;
        File appsDir = null;
        if ("apps".equals(appsDirName)) {
            appsDir = new File(this.serverDirectory, appsDirName);
        } else if ("dropins".equals(appsDirName)) {
            appsDir = new File(this.serverDirectory, appsDirName + "/spring");
        }
        archiveTarget = new File(appsDir, "thin-" + archiveSrc.getName());
        return archiveTarget;
    }

    private File getLibIndexCacheTarget() {
        File sharedDirectory = new File(this.userDirectory, "shared");
        File sharedResourcesDirectory = new File(sharedDirectory, "resources");
        if (!sharedResourcesDirectory.exists()) {
            sharedResourcesDirectory.mkdirs();
        }
        File libIndexCacheTarget = new File(sharedResourcesDirectory, "lib.index.cache");
        return libIndexCacheTarget;
    }

    private boolean isFileExecutable(File archiveSrc) throws IOException {
        String startClass;
        Manifest manifest;
        return archiveSrc.exists() && (manifest = new JarFile(archiveSrc).getManifest()) != null && (startClass = manifest.getMainAttributes().getValue("Start-Class")) != null;
    }

    private String getArtifactExtension() {
        return this.project.getArtifact().getArtifactHandler().getExtension();
    }

    private void installDependencies() throws Exception {
        Set artifacts = this.project.getArtifacts();
        this.log.debug((CharSequence)("Number of compile dependencies for " + this.project.getArtifactId() + " : " + artifacts.size()));
        for (Artifact artifact : artifacts) {
            if (!this.isSupportedType(artifact.getType()) || this.assemblyArtifact != null && this.matches(artifact, this.assemblyArtifact) || !artifact.getScope().equals("compile")) continue;
            if (this.isSupportedType(artifact.getType())) {
                if (this.looseApplication && this.isReactorMavenProject(artifact)) {
                    MavenProject dependProj = this.getReactorMavenProject(artifact);
                    this.installLooseApplication(dependProj);
                    continue;
                }
                this.installApp(this.resolveArtifact(artifact));
                continue;
            }
            this.log.warn((CharSequence)MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    protected void installProject() throws Exception {
        if (this.isSupportedType(this.project.getPackaging())) {
            if (this.looseApplication) {
                this.installLooseApplication(this.project);
            } else {
                this.installApp(this.project.getArtifact());
            }
        } else {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    private void installLooseApplication(MavenProject proj) throws Exception {
        String looseConfigFileName = this.getLooseConfigFileName(proj);
        String application = looseConfigFileName.substring(0, looseConfigFileName.length() - 4);
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        File looseConfigFile = new File(destDir, looseConfigFileName);
        LooseConfigData config = new LooseConfigData();
        switch (proj.getPackaging()) {
            case "war": {
                this.validateAppConfig(application, proj.getArtifactId());
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                this.installLooseConfigWar(proj, config);
                this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
                this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
                config.toXmlFile(looseConfigFile);
                break;
            }
            case "ear": {
                this.validateAppConfig(application, proj.getArtifactId());
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                this.installLooseConfigEar(proj, config);
                this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
                this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
                config.toXmlFile(looseConfigFile);
                break;
            }
            case "liberty-assembly": {
                if (this.mavenWarPluginExists(proj) || new File(proj.getBasedir(), "src/main/webapp").exists()) {
                    this.validateAppConfig(application, proj.getArtifactId());
                    this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                    this.installLooseConfigWar(proj, config);
                    this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
                    this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
                    config.toXmlFile(looseConfigFile);
                    break;
                }
                this.log.debug((CharSequence)"The liberty-assembly project does not contain the maven-war-plugin or src/main/webapp does not exist.");
                break;
            }
            default: {
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.loose.application.not.supported"), proj.getPackaging()));
                this.installApp(proj.getArtifact());
            }
        }
    }

    private void cleanupPreviousExecution() {
        if (ApplicationXmlDocument.getApplicationXmlFile(this.serverDirectory).exists()) {
            ApplicationXmlDocument.getApplicationXmlFile(this.serverDirectory).delete();
        }
    }

    private boolean mavenWarPluginExists(MavenProject proj) {
        for (MavenProject currentProject = proj; currentProject != null; currentProject = currentProject.getParent()) {
            ArrayList plugins = new ArrayList(currentProject.getBuildPlugins());
            plugins.addAll(currentProject.getPluginManagement().getPlugins());
            for (Object o : plugins) {
                Plugin plugin;
                if (!(o instanceof Plugin) || !(plugin = (Plugin)o).getGroupId().equals("org.apache.maven.plugins") || !plugin.getArtifactId().equals("maven-war-plugin")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(Artifact artifact, ArtifactItem assemblyArtifact) {
        return artifact.getGroupId().equals(assemblyArtifact.getGroupId()) && artifact.getArtifactId().equals(assemblyArtifact.getArtifactId()) && artifact.getType().equals(assemblyArtifact.getType());
    }

    private boolean isSupportedType(String type) {
        boolean supported = false;
        switch (type) {
            case "ear": 
            case "war": 
            case "rar": 
            case "eba": 
            case "esa": 
            case "liberty-assembly": {
                supported = true;
                break;
            }
        }
        return supported;
    }
}

