/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.wasdev.wlp.common.plugins.util.XmlDocument;
import org.w3c.dom.Element;

public class ApplicationXmlDocument
extends XmlDocument {
    public static final String APP_XML_FILENAME = "install_apps_configuration_1491924271.xml";

    public ApplicationXmlDocument() {
        try {
            this.createDocument("server");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void createApplicationElement(String appFileName, String artifactId) {
        this.createApplicationElement(appFileName, artifactId, false);
    }

    public void createApplicationElement(String appFileName, String artifactId, boolean isSpringBootApp) {
        File app = new File(appFileName);
        if (isSpringBootApp) {
            this.createElement("springBootApplication", app, artifactId);
            return;
        }
        switch (appFileName.substring(appFileName.lastIndexOf(".") + 1)) {
            case "war": {
                this.createElement("webApplication", app, artifactId);
                break;
            }
            case "ear": {
                this.createElement("enterpriseApplication", app, artifactId);
                break;
            }
            case "rar": {
                this.createElement("resourceAdapter", app, artifactId);
                break;
            }
        }
    }

    public void createElement(String element, File appFile, String artifactId) {
        Element child = this.doc.createElement(element);
        child.setAttribute("id", artifactId);
        child.setAttribute("location", appFile.getName());
        child.setAttribute("name", artifactId);
        this.doc.getDocumentElement().appendChild(child);
    }

    public void writeApplicationXmlDocument(File serverDirectory) throws IOException, TransformerException {
        File applicationXml = ApplicationXmlDocument.getApplicationXmlFile(serverDirectory);
        if (!applicationXml.getParentFile().exists()) {
            applicationXml.getParentFile().mkdirs();
        }
        this.writeXMLDocument(applicationXml);
    }

    public static File getApplicationXmlFile(File serverDirectory) {
        File f = new File(serverDirectory, "configDropins/defaults/install_apps_configuration_1491924271.xml");
        return f;
    }

    public boolean hasChildElements() {
        return this.doc.getDocumentElement().getChildNodes().getLength() > 0;
    }
}

