/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.utils;

import java.util.List;
import net.wasdev.wlp.common.plugins.util.PluginScenarioException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectUtil {
    public static String getPluginConfigurationString(MavenProject project, String pluginKey, String goal, String configName) throws PluginScenarioException {
        Xpp3Dom configElement;
        PluginExecution execution = MavenProjectUtil.getPluginExecution(project, pluginKey, goal);
        Xpp3Dom config = (Xpp3Dom)execution.getConfiguration();
        if (config != null && (configElement = config.getChild(configName)) != null) {
            String value = configElement.getValue().trim();
            return value;
        }
        throw new PluginScenarioException("Could not find configuration string " + configName + " for goal " + goal + " on plugin " + pluginKey);
    }

    public static PluginExecution getPluginExecution(Plugin plugin, String goal) throws PluginScenarioException {
        List executions = plugin.getExecutions();
        for (PluginExecution execution : executions) {
            if (!execution.getGoals().contains(goal)) continue;
            return execution;
        }
        throw new PluginScenarioException("Could not find goal " + goal + " on plugin " + plugin.getKey());
    }

    public static PluginExecution getPluginExecution(MavenProject project, String pluginKey, String goal) throws PluginScenarioException {
        Plugin plugin = project.getPlugin(pluginKey);
        return MavenProjectUtil.getPluginExecution(plugin, goal);
    }
}

