/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import javax.xml.parsers.ParserConfigurationException;
import net.wasdev.wlp.maven.plugins.XmlDocument;
import org.w3c.dom.Element;

public class LooseConfigData
extends XmlDocument {
    public LooseConfigData() throws ParserConfigurationException {
        this.createDocument("archive");
    }

    public void addDir(String src, String target) {
        if (new File(src).exists()) {
            this.addDir(this.doc.getDocumentElement(), src, target);
        }
    }

    public void addDir(Element parent, String src, String target) {
        if (new File(src).exists()) {
            Element child = this.doc.createElement("dir");
            this.addElement(parent, child, target, src);
        }
    }

    public void addFile(String src, String target) {
        if (new File(src).exists()) {
            this.addFile(this.doc.getDocumentElement(), src, target);
        }
    }

    public void addFile(Element parent, String src, String target) {
        if (new File(src).exists()) {
            Element child = this.doc.createElement("file");
            this.addElement(parent, child, target, src);
        }
    }

    public Element addArchive(String target) {
        return this.addArchive(this.doc.getDocumentElement(), target);
    }

    public Element addArchive(Element parent, String target) {
        Element child = this.doc.createElement("archive");
        this.addElement(parent, child, target);
        return child;
    }

    public void addArchive(String src, String target) {
        Element child = this.addArchive(target);
        this.addElement(child, this.doc.createElement("dir"), "/", src);
    }

    public void toXmlFile(File xmlFile) throws Exception {
        this.writeXMLDocument(xmlFile);
    }

    public Element getDocumentRoot() {
        return this.doc.getDocumentElement();
    }

    private void addElement(Element parent, Element child, String targetAttr, String srcAttr) {
        child.setAttribute("sourceOnDisk", srcAttr);
        this.addElement(parent, child, targetAttr);
    }

    private void addElement(Element parent, Element child, String targetAttr) {
        child.setAttribute("targetInArchive", targetAttr);
        parent.appendChild(child);
    }
}

