/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.wasdev.wlp.maven.plugins.ApplicationXmlDocument;
import net.wasdev.wlp.maven.plugins.applications.InstallAppMojoSupport;
import net.wasdev.wlp.maven.plugins.applications.LooseConfigData;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

@Mojo(name="install-apps", requiresDependencyResolution=ResolutionScope.COMPILE)
public class InstallAppsMojo
extends InstallAppMojoSupport {
    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        this.copyConfigFiles();
        this.exportParametersToXml();
        boolean installDependencies = false;
        boolean installProject = false;
        switch (this.getInstallAppPackages()) {
            case "all": {
                installDependencies = true;
                installProject = true;
                break;
            }
            case "dependencies": {
                installDependencies = true;
                break;
            }
            case "project": {
                installProject = true;
                break;
            }
            default: {
                return;
            }
        }
        if (installDependencies) {
            this.installDependencies();
        }
        if (installProject) {
            this.installProject();
        }
        if (this.applicationXml.hasChildElements()) {
            this.log.warn((CharSequence)messages.getString("warn.install.app.add.configuration"));
            this.applicationXml.writeApplicationXmlDocument(this.serverDirectory);
        } else if (ApplicationXmlDocument.getApplicationXmlFile(this.serverDirectory).exists()) {
            ApplicationXmlDocument.getApplicationXmlFile(this.serverDirectory).delete();
        }
    }

    private void installDependencies() throws Exception {
        List deps = this.project.getDependencies();
        for (Dependency dep : deps) {
            if (!this.isSupportedType(dep.getType()) || this.assemblyArtifact != null && this.matches(dep, this.assemblyArtifact) || !dep.getScope().equals("compile")) continue;
            MavenProject dependProj = this.getMavenProject(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
            if (this.isSupportedType(dependProj.getPackaging())) {
                if (this.looseApplication && dependProj.getBasedir() != null && dependProj.getBasedir().exists()) {
                    this.installLooseApplication(dependProj);
                    continue;
                }
                this.installApp(this.resolveArtifact(dependProj.getArtifact()));
                continue;
            }
            this.log.warn((CharSequence)MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    protected void installProject() throws Exception {
        if (this.isSupportedType(this.project.getPackaging())) {
            if (this.looseApplication) {
                this.installLooseApplication(this.project);
            } else {
                this.installApp(this.project.getArtifact());
            }
        } else {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.application.not.supported"), this.project.getId()));
        }
    }

    private void installLooseApplication(MavenProject proj) throws Exception {
        String looseConfigFileName = this.getLooseConfigFileName(proj);
        String application = looseConfigFileName.substring(0, looseConfigFileName.length() - 4);
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        File looseConfigFile = new File(destDir, looseConfigFileName);
        LooseConfigData config = new LooseConfigData();
        switch (proj.getPackaging()) {
            case "war": {
                this.validateAppConfig(application, proj.getArtifactId());
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                this.installLooseConfigWar(proj, config);
                this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
                this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
                config.toXmlFile(looseConfigFile);
                break;
            }
            case "ear": {
                this.validateAppConfig(application, proj.getArtifactId());
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                this.installLooseConfigEar(proj, config);
                this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
                this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
                config.toXmlFile(looseConfigFile);
                break;
            }
            case "liberty-assembly": {
                if (this.mavenWarPluginExists(proj) || new File(proj.getBasedir(), "src/main/webapp").exists()) {
                    this.validateAppConfig(application, proj.getArtifactId());
                    this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), looseConfigFileName));
                    this.installLooseConfigWar(proj, config);
                    this.deleteApplication(new File(this.serverDirectory, "apps"), looseConfigFile);
                    this.deleteApplication(new File(this.serverDirectory, "dropins"), looseConfigFile);
                    config.toXmlFile(looseConfigFile);
                    break;
                }
                this.log.debug((CharSequence)"The liberty-assembly project does not contain the maven-war-plugin or src/main/webapp does not exist.");
                break;
            }
            default: {
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.loose.application.not.supported"), proj.getPackaging()));
                this.installApp(proj.getArtifact());
            }
        }
    }

    private boolean mavenWarPluginExists(MavenProject proj) {
        for (MavenProject currentProject = proj; currentProject != null; currentProject = currentProject.getParent()) {
            ArrayList plugins = new ArrayList(currentProject.getBuildPlugins());
            plugins.addAll(currentProject.getPluginManagement().getPlugins());
            for (Object o : plugins) {
                Plugin plugin;
                if (!(o instanceof Plugin) || !(plugin = (Plugin)o).getGroupId().equals("org.apache.maven.plugins") || !plugin.getArtifactId().equals("maven-war-plugin")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(Dependency dep, ArtifactItem assemblyArtifact) {
        return dep.getGroupId().equals(assemblyArtifact.getGroupId()) && dep.getArtifactId().equals(assemblyArtifact.getArtifactId()) && dep.getType().equals(assemblyArtifact.getType());
    }

    private boolean isSupportedType(String type) {
        boolean supported = false;
        switch (type) {
            case "ear": 
            case "war": 
            case "rar": 
            case "eba": 
            case "esa": 
            case "liberty-assembly": {
                supported = true;
                break;
            }
        }
        return supported;
    }
}

