/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import net.wasdev.wlp.maven.plugins.ApplicationXmlDocument;
import net.wasdev.wlp.maven.plugins.applications.LooseApplication;
import net.wasdev.wlp.maven.plugins.applications.LooseConfigData;
import net.wasdev.wlp.maven.plugins.applications.LooseEarApplication;
import net.wasdev.wlp.maven.plugins.applications.LooseWarApplication;
import net.wasdev.wlp.maven.plugins.server.PluginConfigSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Copy;
import org.w3c.dom.Element;

public class InstallAppMojoSupport
extends PluginConfigSupport {
    protected ApplicationXmlDocument applicationXml = new ApplicationXmlDocument();

    protected void installApp(Artifact artifact) throws Exception {
        if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
            String warName = this.getAppFileName(this.project);
            File f = new File(this.project.getBuild().getDirectory() + "/" + warName);
            artifact.setFile(f);
        }
        if (!artifact.getFile().exists()) {
            throw new MojoExecutionException(messages.getString("error.install.app.missing"));
        }
        File destDir = new File(this.serverDirectory, this.getAppsDirectory());
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), artifact.getFile().getCanonicalPath()));
        Copy copyFile = (Copy)this.ant.createTask("copy");
        copyFile.setFile(artifact.getFile());
        String fileName = artifact.getFile().getName();
        if (this.stripVersion) {
            fileName = this.stripVersionFromName(fileName, artifact.getVersion());
            copyFile.setTofile(new File(destDir, fileName));
        } else {
            copyFile.setTodir(destDir);
        }
        this.validateAppConfig(fileName, artifact.getArtifactId());
        this.deleteApplication(new File(this.serverDirectory, "apps"), artifact.getFile());
        this.deleteApplication(new File(this.serverDirectory, "dropins"), artifact.getFile());
        this.deleteApplication(new File(this.serverDirectory, "apps/expanded"), artifact.getFile());
        copyFile.execute();
    }

    protected void installLooseConfigWar(MavenProject proj, LooseConfigData config) throws Exception {
        File dir = new File(proj.getBuild().getOutputDirectory());
        if (!dir.exists() && this.containsJavaSource(proj)) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.project.not.compile"), proj.getId()));
        }
        LooseWarApplication looseWar = new LooseWarApplication(proj, config);
        looseWar.addSourceDir(proj);
        looseWar.addOutputDir(looseWar.getDocumentRoot(), proj, "/WEB-INF/classes");
        this.addEmbeddedLib(looseWar.getDocumentRoot(), proj, looseWar, "/WEB-INF/lib/");
        looseWar.addManifestFile(proj, "maven-war-plugin");
    }

    protected void installLooseConfigEar(MavenProject proj, LooseConfigData config) throws Exception {
        LooseEarApplication looseEar = new LooseEarApplication(proj, config);
        looseEar.addSourceDir();
        looseEar.addApplicationXmlFile();
        List deps = proj.getDependencies();
        block12: for (Dependency dep : deps) {
            if (!"compile".equals(dep.getScope())) continue;
            MavenProject dependencyProject = this.getMavenProject(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
            if (dependencyProject.getBasedir() == null || !dependencyProject.getBasedir().exists()) {
                if (looseEar.isEarSkinnyWars().booleanValue() && "war".equals(dep.getType())) {
                    throw new MojoExecutionException("Unable to create loose configuration for the EAR application with skinnyWars package from " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + ". Please set the looseApplication configuration parameter to false and try again.");
                }
                looseEar.addModuleFromM2(dependencyProject, this.resolveArtifact(dependencyProject.getArtifact()));
                continue;
            }
            switch (dep.getType()) {
                case "jar": {
                    looseEar.addJarModule(dependencyProject);
                    continue block12;
                }
                case "ejb": {
                    looseEar.addEjbModule(dependencyProject);
                    continue block12;
                }
                case "war": {
                    Element warArchive = looseEar.addWarModule(dependencyProject, this.getWarSourceDirectory(dependencyProject).getCanonicalPath());
                    if (looseEar.isEarSkinnyWars().booleanValue()) {
                        this.addSkinnyWarLib(warArchive, dependencyProject, looseEar);
                        continue block12;
                    }
                    this.addEmbeddedLib(warArchive, dependencyProject, looseEar, "/WEB-INF/lib/");
                    continue block12;
                }
                case "rar": {
                    Element rarArchive = looseEar.addRarModule(dependencyProject);
                    this.addEmbeddedLib(rarArchive, dependencyProject, looseEar, "/");
                    continue block12;
                }
            }
            looseEar.addModuleFromM2(dependencyProject, this.resolveArtifact(dependencyProject.getArtifact()));
        }
        looseEar.addManifestFile(proj, "maven-ear-plugin");
    }

    private void addEmbeddedLib(Element parent, MavenProject proj, LooseApplication looseApp, String dir) throws Exception {
        List deps = proj.getDependencies();
        for (Dependency dep : deps) {
            if (!"compile".equals(dep.getScope()) || !"jar".equals(dep.getType())) continue;
            this.addlibrary(parent, looseApp, dir, dep);
        }
    }

    private void addSkinnyWarLib(Element parent, MavenProject proj, LooseEarApplication looseEar) throws Exception {
        List deps = proj.getDependencies();
        for (Dependency dep : deps) {
            if (!"compile".equals(dep.getScope()) || !"jar".equals(dep.getType()) || looseEar.isEarCompileDependency(dep)) continue;
            this.addlibrary(parent, looseEar, "/WEB-INF/lib/", dep);
        }
    }

    private void addlibrary(Element parent, LooseApplication looseApp, String dir, Dependency dep) throws Exception {
        MavenProject dependProject = this.getMavenProject(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
        if (dependProject.getBasedir() != null && dependProject.getBasedir().exists()) {
            Element archive = looseApp.addArchive(parent, dir + dependProject.getBuild().getFinalName() + ".jar");
            looseApp.addOutputDir(archive, dependProject, "/");
            looseApp.addManifestFile(archive, dependProject, "maven-jar-plugin");
        } else {
            looseApp.getConfig().addFile(parent, this.resolveArtifact(dependProject.getArtifact()).getFile().getAbsolutePath(), dir + this.resolveArtifact(dependProject.getArtifact()).getFile().getName());
        }
    }

    private boolean containsJavaSource(MavenProject proj) {
        List srcDirs = proj.getCompileSourceRoots();
        for (String dir : srcDirs) {
            File javaSourceDir = new File(dir);
            if (!javaSourceDir.exists() || !javaSourceDir.isDirectory() || !this.containsJavaSource(javaSourceDir)) continue;
            return true;
        }
        return false;
    }

    private boolean containsJavaSource(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".java")) {
                return true;
            }
            if (!file.isDirectory()) continue;
            return this.containsJavaSource(file);
        }
        return false;
    }

    protected String getLooseConfigFileName(MavenProject project) {
        return this.getAppFileName(project) + ".xml";
    }

    private String getAppFileName(MavenProject project) {
        String name = project.getBuild().getFinalName() + "." + project.getPackaging();
        if (project.getPackaging().equals("liberty-assembly")) {
            name = project.getBuild().getFinalName() + ".war";
        }
        if (this.stripVersion) {
            name = this.stripVersionFromName(name, project.getVersion());
        }
        return name;
    }

    protected void validateAppConfig(String fileName, String artifactId) throws Exception {
        String appsDir = this.getAppsDirectory();
        if (appsDir.equalsIgnoreCase("apps") && !this.isAppConfiguredInSourceServerXml(fileName)) {
            this.applicationXml.createApplicationElement(fileName, artifactId);
        } else if (appsDir.equalsIgnoreCase("dropins") && this.isAppConfiguredInSourceServerXml(fileName)) {
            throw new MojoExecutionException(messages.getString("error.install.app.dropins.directory"));
        }
    }
}

