/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.text.MessageFormat;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.maven.plugins.server.StartDebugMojoSupport;
import org.apache.maven.plugin.MojoExecutionException;

public class StartServerMojo
extends StartDebugMojoSupport {
    private int verifyTimeout = 30;
    private int serverStartTimeout = 30;
    private String applications;
    protected boolean clean;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
        }
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setClean(this.clean);
        serverTask.setOperation("start");
        if (this.serverStartTimeout < 0) {
            this.serverStartTimeout = 30;
        }
        serverTask.setTimeout(Long.toString(this.serverStartTimeout * 1000));
        serverTask.execute();
        if (this.verifyTimeout < 0) {
            this.verifyTimeout = 30;
        }
        long timeout = this.verifyTimeout * 1000;
        long endTime = System.currentTimeMillis() + timeout;
        if (this.applications != null) {
            String[] apps;
            for (String archiveName : apps = this.applications.split("[,\\s]+")) {
                String startMessage = serverTask.waitForStringInLog("CWWKZ0001I.*" + archiveName, timeout, serverTask.getLogFile());
                if (startMessage == null) {
                    this.stopServer();
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.start.verify"), this.verifyTimeout));
                }
                timeout = endTime - System.currentTimeMillis();
            }
        }
    }

    private void stopServer() {
        try {
            ServerTask serverTask = this.initializeJava();
            serverTask.setOperation("stop");
            serverTask.execute();
        }
        catch (Exception e) {
            this.log.debug((CharSequence)"Error stopping server", (Throwable)e);
        }
    }
}

