/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.text.MessageFormat;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.tools.ant.taskdefs.Copy;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

public class InstallAppsMojo
extends BasicSupport {
    protected String appsDirectory = null;
    protected boolean stripVersion;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        File destDir = new File(this.serverDirectory, this.appsDirectory);
        for (Artifact dep : this.project.getDependencyArtifacts()) {
            if (this.assemblyArtifact != null && this.matches(dep, this.assemblyArtifact) || !dep.getScope().equals("compile")) continue;
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.app"), dep.getFile().getCanonicalPath()));
            Copy copyFile = (Copy)this.ant.createTask("copy");
            copyFile.setFile(dep.getFile());
            if (this.stripVersion) {
                copyFile.setTofile(new File(destDir, dep.getArtifactId() + "." + dep.getType()));
            } else {
                copyFile.setTodir(destDir);
            }
            copyFile.execute();
        }
    }

    private boolean matches(Artifact dep, ArtifactItem assemblyArtifact) {
        return dep.getGroupId().equals(assemblyArtifact.getGroupId()) && dep.getArtifactId().equals(assemblyArtifact.getArtifactId()) && dep.getType().equals(assemblyArtifact.getType());
    }
}

