/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.tools.ant.taskdefs.Copy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartDebugMojoSupport
extends BasicSupport {
    private static final String HEADER = "# Generated by liberty-maven-plugin";
    protected File configFile;
    protected File bootstrapPropertiesFile;
    protected Map<String, String> bootstrapProperties;
    protected File jvmOptionsFile;
    protected List<String> jvmOptions;
    protected File serverEnv;
    protected boolean overwrite;

    protected ServerTask initializeJava() throws Exception {
        ServerTask serverTask = (ServerTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:server");
        if (serverTask == null) {
            throw new NullPointerException("server task not found");
        }
        serverTask.setInstallDir(this.installDirectory);
        serverTask.setServerName(this.serverName);
        serverTask.setUserDir(this.userDirectory);
        serverTask.setOutputDir(this.outputDirectory);
        return serverTask;
    }

    protected void copyConfigFiles() throws IOException {
        this.copyConfigFiles(this.overwrite);
    }

    protected void copyConfigFiles(boolean overwrite) throws IOException {
        Copy copy;
        if (this.configFile != null && this.configFile.exists()) {
            Copy copy2 = (Copy)this.ant.createTask("copy");
            copy2.setFile(this.configFile);
            copy2.setTofile(new File(this.serverDirectory, "server.xml"));
            copy2.setOverwrite(overwrite);
            copy2.execute();
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.xml", this.configFile.getCanonicalPath()));
        }
        File optionsFile = new File(this.serverDirectory, "jvm.options");
        if (this.jvmOptions != null) {
            if (overwrite || !optionsFile.exists()) {
                this.writeJvmOptions(optionsFile, this.jvmOptions);
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "jvm.options", "inlined configuration"));
            }
        } else if (this.jvmOptionsFile != null && this.jvmOptionsFile.exists()) {
            Copy copy3 = (Copy)this.ant.createTask("copy");
            copy3.setFile(this.jvmOptionsFile);
            copy3.setTofile(optionsFile);
            copy3.setOverwrite(overwrite);
            copy3.execute();
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "jvm.options", this.jvmOptionsFile.getCanonicalPath()));
        }
        File bootstrapFile = new File(this.serverDirectory, "bootstrap.properties");
        if (this.bootstrapProperties != null) {
            if (overwrite || !bootstrapFile.exists()) {
                this.writeBootstrapProperties(bootstrapFile, this.bootstrapProperties);
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "bootstrap.properties", "inlined configuration"));
            }
        } else if (this.bootstrapPropertiesFile != null && this.bootstrapPropertiesFile.exists()) {
            copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.bootstrapPropertiesFile);
            copy.setTofile(bootstrapFile);
            copy.setOverwrite(overwrite);
            copy.execute();
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "bootstrap.properties", this.bootstrapPropertiesFile.getCanonicalPath()));
        }
        if (this.serverEnv != null && this.serverEnv.exists()) {
            copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.serverEnv);
            copy.setTofile(new File(this.serverDirectory, "server.env"));
            copy.setOverwrite(overwrite);
            copy.execute();
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.env", this.serverEnv.getCanonicalPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBootstrapProperties(File file, Map<String, String> properties) throws IOException {
        this.makeParentDirectory(file);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                writer.print(entry.getKey());
                writer.print("=");
                writer.println(entry.getValue());
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJvmOptions(File file, List<String> options) throws IOException {
        this.makeParentDirectory(file);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (String option : options) {
                writer.println(option);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void makeParentDirectory(File file) {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
    }
}

