/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.io.File;
import java.text.MessageFormat;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.maven.plugins.server.StartDebugMojoSupport;
import org.apache.maven.plugin.MojoFailureException;

public class PackageServerMojo
extends StartDebugMojoSupport {
    private File packageFile = null;
    private String include;
    private boolean attach;

    protected void doExecute() throws Exception {
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
            this.checkServerDirectoryExists();
        }
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.package"), this.serverName));
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setOperation("package");
        if (this.packageFile != null) {
            if (this.packageFile.isDirectory()) {
                this.packageFile = new File(this.packageFile, this.serverName + ".zip");
            }
        } else {
            this.packageFile = new File(this.serverDirectory, this.serverName + ".zip");
        }
        serverTask.setArchive(this.packageFile);
        serverTask.setInclude(this.include);
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.package.file.location"), this.packageFile.getCanonicalPath()));
        serverTask.execute();
        if (this.attach || this.project != null && "liberty-assembly".equals(this.project.getPackaging())) {
            if (this.project == null) {
                throw new MojoFailureException(MessageFormat.format(messages.getString("error.server.package.no.project"), ""));
            }
            this.project.getArtifact().setFile(this.packageFile);
        }
    }
}

