/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.text.MessageFormat;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.maven.plugins.server.StartDebugMojoSupport;

public class JavaDumpServerMojo
extends StartDebugMojoSupport {
    private boolean heapDump;
    private boolean systemDump;

    protected void doExecute() throws Exception {
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
            this.checkServerDirectoryExists();
        }
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setOperation("javadump");
        serverTask.setInclude(this.generateInclude());
        serverTask.execute();
    }

    private String generateInclude() {
        StringBuilder builder = new StringBuilder();
        if (this.heapDump) {
            builder.append("heap");
        }
        if (this.systemDump) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            builder.append("system");
        }
        return builder.length() == 0 ? null : builder.toString();
    }
}

